ORCA/M Asm65816 2.1.0

0001 D8A3                       title 'Desk Manager--NDA Calls'
0002 D8A3              **********************************************************************
0003 D8A3              *
0004 D8A3              * Desk Manager  
0005 D8A3              * for the Apple II GS
0006 D8A3              *
0007 D8A3              * original CDA code by John Worthinton.
0008 D8A3              * original NDA code by Steven Glass
0009 D8A3              *
0010 D8A3              * Additions and alterations by Steven Glass and
0011 D8A3              * Konstantin Othmer
0012 D8A3              *
0013 D8A3              * 5.x work by Harry Yee and Mensch
0014 D8A3              *
0015 D8A3              * System 6.0 work by Dave Lyons
0016 D8A3              *
0017 D8A3              * This file contains
0018 D8A3              *
0019 D8A3              *	SystemEvent
0020 D8A3              *	CheckNDAStuff
0021 D8A3              *	CallCDAMenu
0022 D8A3              *	InstallNDA
0023 D8A3              *	OpenNDA
0024 D8A3              *	CloseNDA
0025 D8A3              *	CloseNDAByWinPtr
0026 D8A3              *	CloseAllNDAs2
0027 D8A3              *	DoCloseStuff
0028 D8A3              *	SystemTask
0029 D8A3              *	SystemClick
0030 D8A3              *	SystemEdit
0031 D8A3              *	FixAppleMenu2
0032 D8A3              *	GetNumNDAs
0033 D8A3              *	DeskUtils
0034 D8A3              *	FindThisWindow
0035 D8A3              *	AreWeTop
0036 D8A3              *	SendAction
0037 D8A3              *	SendOpen
0038 D8A3              *	SendClose
0039 D8A3              *	SendInit
0040 D8A3              *	StartNDACall
0041 D8A3              *	EndNDACall
0042 D8A3              *	AddToRunQ
0043 D8A3              *	RemoveFromRunQ
0044 D8A3              *	ExecuteRunItem
0045 D8A3              *	RemoveNDA
0046 D8A3              *
0047 D8A3              **********************************************************************
0048 D8A3
0049 D8A3              **********************************************************************
0050 D8A3              *                                                                    *
0051 D8A3              *                   Copyright (C) 1985-1989                          *
0052 D8A3              *                   All Rights Reserved                              *
0053 D8A3              *                   Apple Computer, Inc.                             *
0054 D8A3              *                                                                    *
0055 D8A3              **********************************************************************
0056 D8A3
0057 D8A3
0058 D8A3              **********************************************************************
0059 D8A3              *
0060 D8A3              * Change History
0061 D8A3              *
0062 D8A3              * 19 Feb 89         Steven Glass
0063 D8A3              *
0064 D8A3              * Made this work with resource manager.
0065 D8A3              *
0066 D8A3              * 15 Mar 89         Steven Glass
0067 D8A3              *
0068 D8A3              * Added FrontToAX to call front window for other routines.  Saved
0069 D8A3              * lots of calls.
0070 D8A3              *
0071 D8A3              * SystemClick selects window if grow clicked in back window
0072 D8A3              * instead of growing.
0073 D8A3              *
0074 D8A3              * 3/16/89           Mensch
0075 D8A3              * Added stilldown call to clickinDrag routine, selecting the window was
0076 D8A3              * occuring too slowly, and there was enough time to click somewhere else
0077 D8A3              * before draw was being called.
0078 D8A3              *
0079 D8A3              * 19 Apr 89         Steven Glass
0080 D8A3              *
0081 D8A3              * Fixed bug in SystemEdit where return code from DA was trashed while 
0082 D8A3              * restoring the resource manager's user id.
0083 D8A3              *
0084 D8A3              * 02 Jun 89         Steven Glass
0085 D8A3              *
0086 D8A3              * Fixed bugs relating to re-entrancy.  When the desk manager
0087 D8A3              * is re-entered the handle is locked and unlocked, leaving the first
0088 D8A3              * entry with a dangling pointer.  We now inc a counter and dec a 
0089 D8A3              * counter so that the unlock only occurs when the counter gets to zero.
0090 D8A3              *
0091 D8A3              * 28 Aug 89         Harry Yee
0092 D8A3              * Fixed bugs relating to fix made 02 Jun 89. The counter thats inc'ed
0093 D8A3              * is done in routine DerefNDAList and dec'ed in UnlockNDAList. This 
0094 D8A3              * counter gets imbalanced on occasion because the routines GetNumNDAs,
0095 D8A3              * AddtoRunQ, and RemoveFromRunQ call DerefNDAList but not UnlockNDAList.
0096 D8A3              * I now make sure both calls are made. BRC #52333. This fixes the 
0097 D8A3              * problem for ROM 01 machines but not for ROM 03. Fix must be made in
0098 D8A3              * the desk mgr patch file.
0099 D8A3              *
0100 D8A3              * 15 Feb 90         Harry Yee
0101 D8A3              * Fix bug in RemoveNDA. The ptr PtrToThisOne was being used to keep track
0102 D8A3              * of where the next NDA was to be moved to. This ptr was never updated 
0103 D8A3              * during each iteration of the loop that moved all NDAs up one position.
0104 D8A3              *
0105 D8A3              * 17-Sep-90         Dave Lyons
0106 D8A3              * Removed dependency on all.macros.
0107 D8A3              *
0108 D8A3              **********************************************************************
0109 D8A3
0110 D8A3                       include 'all.macros' 
0111 D8A3
0112 D8A3                       include '::sys.equs.asm' 
0113 D8A3                       include 'Desk.Equates.asm' 
0114 D8A3                       include 'e16.memory' 
0115 D8A3
0116 D8A3
0117 D8A3                       title 'Desk Manager--desk/DESK.SRC'
0118 D8A3              *****************************************************************
0119 D8A3              *
0120 D8A3              * System Event
0121 D8A3              *
0122 D8A3              *         result  :  boolean     (word)
0123 D8A3              *         mods    :  modifiers   (long)
0124 D8A3              *         where   :  point       (long)
0125 D8A3              *         when    :  long
0126 D8A3              *         message :  long
0127 D8A3              *         what   :   event code  (word)
0128 D8A3              *   SP->
0129 D8A3              *
0130 D8A3              * Apologies to those who follow but we had to perform a little
0131 D8A3              * kludge here.  The ChoseCDA routine in ROM does a silly thing
0132 D8A3              * to decide how to get input.  It loads the address of an
0133 D8A3              * input routine decrements it once and does an RTS.  This
0134 D8A3              * address unfortunatley is setup by SystemEvent.  With this
0135 D8A3              * patch, SystemEvent is not in the same bank and does not
0136 D8A3              * know the addresses of the input routines.
0137 D8A3              *
0138 D8A3              * So what do I do?  Well the input routine not to use has its
0139 D8A3              * address in the variable KeyINput.  It is easy to save and
0140 D8A3              * restore it without caring what it is.  The routine that
0141 D8A3              * we need to use is $D bytes after the routine not to use.
0142 D8A3              *
0143 D8A3              * Without knowing where it is I can guarentee that the routine
0144 D8A3              * will not change size or relative position in future ROMs.
0145 D8A3              *
0146 D8A3              * Thus I calculate the address of the routine to use by adding
0147 D8A3              * $D to the address of the routine not to use.
0148 D8A3              *
0149 D8A3              * This routine also has to prevent multiple entries into the
0150 D8A3              * CDA menu.  I do this by checking a flag on entry.  If this
0151 D8A3              * flag is non zero we skip the work.  If the flag is zero,
0152 D8A3              * we set the flag to non zero and bring up the menu.  When
0153 D8A3              * we return from the menu, we set the flag back to zero.
0154 D8A3              *
0155 D8A3              * Modification History
0156 D8A3              *
0157 D8A3              * 01 Oct 87    Steven Glass
0158 D8A3              *
0159 D8A3              * Routine rewritten to run in ROM.
0160 D8A3              *
0161 D8A3              *
0162 D8A3              * 31 Mar 88         Steven Glass
0163 D8A3              *
0164 D8A3              * This code now checks to see if the CDA menu is active before
0165 D8A3              * trying to pass events to NDAs.
0166 D8A3              *
0167 D8A3              * 12/5/89           Mensch
0168 D8A3              *
0169 D8A3              * Added code so that system event does not claim certain keyboard events. This allows
0170 D8A3              * DA's to accept certain menu key equivalents.
0171 D8A3              *
0172 D8A3              ****************************************************************
0173 D8A3                       EXPORT SystemEvent 
0174 D8A3              SystemEvent PROC EXPORT 
0175 D8A3
0176 D8A3
0177 D8A3                       DefineStack 
0178 D8A3              OrigD    word 
0179 D8A3              DAPtr    long 
0180 D8A3              DAHandle long 
0181 D8A3              procstat byte 
0182 D8A3              ret1     block 3
0183 D8A3              ret2     block 3
0184 D8A3              swhat    word 
0185 D8A3              smessage long 
0186 D8A3              swhen    long 
0187 D8A3              swhere   long 
0188 D8A3              smods    word 
0189 D8A3              result   word 
0190 D8A3
0191 D8A3
0192 D8A3              SizeOfMonKeyIn equ   $D
0193 D8A3
0194 D8A3 08                    php                            ; turn off interrupts because
0195 D8A4 78                    sei                            ; dahandler expects them off
0196 D8A5
0197 D8A5 5A                    phy                            ; save handle to data structure
0198 D8A6 48                    pha                            ; on stack (value from WAP table)
0199 D8A7 5A                    phy                            ; save again to make room for
0200 D8A8 48                    pha                            ; pointer.
0201 D8A9 0B                    phd                            ; save direct page
0202 D8AA 3B                    tsc                            ; get stack pointer
0203 D8AB 5B                    tcd                            ; make it direct
0204 D8AC
0205 D8AC 64 22                 stz   Result                   ; assume that we will not handle this event
0206 D8AE
0207 D8AE A5 12                 lda   swhat                    ; get the event type
0208 D8B0 C9 0A 00              cmp   #$000A                   ; is it a DA event
0209 D8B3 F0 0D                 beq   ItsNDAEvent
0210 D8B5
0211 D8B5              ;-------------------------------------------------
0212 D8B5              ;
0213 D8B5              ; Look at the NotAgain flag.  If it is set,
0214 D8B5              ; we cannot send events to an NDA.
0215 D8B5              ;
0216 D8B5 20 3F D9              jsr   LocalDeref
0217 D8B8
0218 D8B8 A0 04 00              ldy   #o_NotAgain
0219 D8BB B7 03                 lda   [DAPtr],y
0220 D8BD D0 76                 bne   CannotGoOn
0221 D8BF
0222 D8BF 82 89 00              brl   CheckNDAStuff            ; No, move on.
0223 D8C2
0224 D8C2              ItsNDAEvent  
0225 D8C2              ;-------------------------------------------------
0226 D8C2              ;
0227 D8C2              ; It is a DA event.  We will have to try to call
0228 D8C2              ; the CDA menu but...
0229 D8C2              ;
0230 D8C2              ;
0231 D8C2              ; Calling SaveScrn clobbers the important variable
0232 D8C2              ; NumInts.  So I save NumInts here and restore it
0233 D8C2              ; below.
0234 D8C2              ;
0235 D8C2 E2 30                 sep   #$30
0236 D8C4 AF 67 1D E0           lda   >NumInts                 ; get num ints and
0237 D8C8 48                    pha   
0238 D8C9 C2 30                 rep   #$30
0239 D8CB
0240 D8CB              ;-------------------------------------------------
0241 D8CB              ;
0242 D8CB              ; Look at the NotAgain flag.  If it is set,
0243 D8CB              ; we cannot do this again.
0244 D8CB              ;
0245 D8CB 20 3F D9              jsr   LocalDeref
0246 D8CE
0247 D8CE A0 04 00              ldy   #o_NotAgain
0248 D8D1 B7 03                 lda   [DAPtr],y
0249 D8D3 D0 52                 bne   SkipThisOne
0250 D8D5
0251 D8D5              ;-------------------------------------------------
0252 D8D5              ;
0253 D8D5              ; Set the KeyInput field so that right routine
0254 D8D5              ; is called.  (Save orig KeyInput on stack.)
0255 D8D5              ;
0256 D8D5 AF 8A 1D E0           lda   >keyinput
0257 D8D9 48                    pha   
0258 D8DA 18                    clc   
0259 D8DB 69 0D 00              adc   #SizeofMonKeyIn
0260 D8DE 8F 8A 1D E0           sta   >keyinput
0261 D8E2
0262 D8E2              ;-------------------------------------------------
0263 D8E2              ;
0264 D8E2              ; Zero the Active flag so that we do not send
0265 D8E2              ; keystrokes to NDA's on screen that cannot be
0266 D8E2              ; seen by user.  (Save for later restoration.)
0267 D8E2              ;
0268 D8E2 A0 02 00              ldy   #o_ActiveFlag
0269 D8E5 B7 03                 lda   [DAPtr],y
0270 D8E7 48                    pha   
0271 D8E8 A9 00 00              lda   #0
0272 D8EB 97 03                 sta   [DAPtr],y
0273 D8ED
0274 D8ED              ;-------------------------------------------------
0275 D8ED              ;
0276 D8ED              ; Set notagain flag to prevent multiple entries
0277 D8ED              ; into CDA menu.
0278 D8ED              ;
0279 D8ED A0 04 00              ldy   #o_NotAgain
0280 D8F0 A9 00 80              lda   #$8000
0281 D8F3 97 03                 sta   [DAPtr],y
0282 D8F5
0283 D8F5              ;-------------------------------------------------
0284 D8F5              ;
0285 D8F5              ; Save current shadow register and set it for
0286 D8F5              ; use by CDA menu.
0287 D8F5              ;
0288 D8F5 E2 30                 sep   #$30
0289 D8F7                       longa off
0290 D8F7                       longi off
0291 D8F7 AF 35 C0 00           lda   >Shadow
0292 D8FB 48                    pha   
0293 D8FC 29 FE                 and   #$FE                     ; force text shawdow on
0294 D8FE 8F 35 C0 00           sta   >Shadow
0295 D902 C2 30                 rep   #$30
0296 D904                       longa on
0297 D904                       longi on
0298 D904
0299 D904              ;-------------------------------------------------
0300 D904              ;
0301 D904              ; Display the CDA menu and run any CDAs.
0302 D904              ;
0303 D904
0304 D904 22 1E DA FE           jsl   CallCDAMenu
0305 D908
0306 D908              ;-------------------------------------------------
0307 D908              ;
0308 D908              ; Restore the shadow register
0309 D908              ;
0310 D908 E2 30                 sep   #$30
0311 D90A                       longa off
0312 D90A                       longi off
0313 D90A 68                    pla   
0314 D90B 8F 35 C0 00           sta   >Shadow
0315 D90F C2 30                 rep   #$30
0316 D911                       longa on
0317 D911                       longi on
0318 D911
0319 D911
0320 D911              ;-------------------------------------------------
0321 D911              ;
0322 D911              ; Restore pointer to global data and restore
0323 D911              ; the ActiveFlag.  Then clear the NotAgain flag.
0324 D911              ;
0325 D911 20 3F D9              jsr   LocalDeref
0326 D914
0327 D914 A0 02 00              ldy   #o_ActiveFlag
0328 D917 68                    pla   
0329 D918 97 03                 sta   [DAPtr],y
0330 D91A
0331 D91A A0 04 00              ldy   #o_NotAgain
0332 D91D A9 00 00              lda   #0
0333 D920 97 03                 sta   [DAPtr],y
0334 D922
0335 D922              ;-------------------------------------------------
0336 D922              ;
0337 D922              ; Restore original value of KeyInput (from
0338 D922              ; stack).
0339 D922              ;
0340 D922 68                    pla   
0341 D923 8F 8A 1D E0           sta   >keyinput
0342 D927
0343 D927
0344 D927              SkipThisOne                             ;
0345 D927 A9 01 00              lda   #$01                     ; nil means I handled the event
0346 D92A 85 22                 sta   result
0347 D92C
0348 D92C
0349 D92C              ;-----------------------------------------------------
0350 D92C              ;
0351 D92C              ; Restore the NumInts variable from above
0352 D92C              ;
0353 D92C E2 30                 sep   #$30
0354 D92E 68                    pla   
0355 D92F 8F 67 1D E0           sta   >NumInts
0356 D933 C2 30                 rep   #$30
0357 D935
0358 D935
0359 D935
0360 D935              CannotGoOn  
0361 D935 2B                    pld                            ; restore the direct page register
0362 D936 68                    pla                            ; pull off the 8 bytes used
0363 D937 68                    pla                            ; for DAHandle and DAPtr
0364 D938 68                    pla   
0365 D939 68                    pla   
0366 D93A
0367 D93A 28                    plp                            ; restore interrupt status
0368 D93B
0369 D93B 5C 91 FC FE           jml   oEndCall16
0370 D93F
0371 D93F
0372 D93F
0373 D93F A7 07        LocalDeref lda   [DAHandle]
0374 D941 85 03                 sta   DAPtr
0375 D943 A0 02 00              ldy   #2
0376 D946 B7 07                 lda   [DAHandle],y
0377 D948 85 05                 sta   DAPtr+2
0378 D94A 60                    rts   
0379 D94B
0380 D94B
0381 D94B                       ENDP 
0382 D94B
0383 D94B
0384 D94B
0385 D94B              ****************************************************************
0386 D94B              *
0387 D94B              * CheckNDAStuff
0388 D94B              *
0389 D94B              * We look at the event type.  For certain events I pass them
0390 D94B              * to the Active DA.  For others, I do not.
0391 D94B              *
0392 D94B              ****************************************************************
0393 D94B                       EXPORT CheckNDAStuff 
0394 D94B              CheckNDAStuff PROC 
0395 D94B
0396 D94B 2B                    pld                            ; restore direct page
0397 D94C 68                    pla                            ; get WAP values back in A & Y
0398 D94D 7A                    ply   
0399 D94E 68                    pla   
0400 D94F 7A                    ply   
0401 D950 28                    plp                            ; restore interrupt state
0402 D951
0403 D951 5A                    phy   
0404 D952 48                    pha   
0405 D953 5A                    phy   
0406 D954 48                    pha   
0407 D955 0B                    phd   
0408 D956 3B                    tsc   
0409 D957 5B                    tcd   
0410 D958
0411 D958
0412 D958              ;-------------------------------------------------
0413 D958              ;
0414 D958              ; Direct page equates until StartNDACall is made.
0415 D958              ;
0416 D958
0417 D958                       DefineStack 
0418 D958              OrigD    word 
0419 D958              DAPtr    long 
0420 D958              DAHandle long 
0421 D958              sret1    block 3 
0422 D958              sret2    block 3 
0423 D958              swhat    word 
0424 D958              smessage long 
0425 D958              swhen    long 
0426 D958              swhere   long 
0427 D958              smods    word 
0428 D958              sresult  word 
0429 D958
0430 D958 A5 11                 lda   swhat
0431 D95A 0A                    asl   a                        ; double the event type
0432 D95B AA                    tax                            ; and put in x for later
0433 D95C
0434 D95C A7 07                 lda   [DAHandle]
0435 D95E 85 03                 sta   DAPtr
0436 D960 A0 02 00              ldy   #2
0437 D963 B7 07                 lda   [DAHandle],y
0438 D965 85 05                 sta   DAPtr+2
0439 D967 A0 02 00              ldy   #o_ActiveFlag
0440 D96A B7 03                 lda   [DAPtr],y
0441 D96C D0 05                 bne   WeAreActive
0442 D96E
0443 D96E A9 00 00              lda   #0
0444 D971 80 0D                 bra   NeverMind
0445 D973
0446 D973 E0 12 00     WeAreActive cpx   #18
0447 D976 90 05                 bcc   ValidEvent
0448 D978 A9 00 00              lda   #0
0449 D97B 80 03                 bra   NeverMind
0450 D97D
0451 D97D FC 8B D9     ValidEvent jsr   (EventTable,x)
0452 D980
0453 D980              NeverMind  
0454 D980 85 21        StoreResult sta   sResult
0455 D982
0456 D982 2B                    pld                            ; clean up the stack
0457 D983 68                    pla   
0458 D984 68                    pla   
0459 D985 68                    pla   
0460 D986 68                    pla   
0461 D987 5C 91 FC FE           jml   oEndCall16
0462 D98B
0463 D98B
0464 D98B AB D9        EventTable DC W:Ignore                  ; 0  null events
0465 D98D AB D9                 DC W:Ignore                    ; 1  mouse down
0466 D98F AF D9                 DC W:DoIfWants                 ; 2  mouse upt
0467 D991 AF D9                 DC W:DoIfWants                 ; 3  key down
0468 D993 AF D9                 DC W:DoIfWants                 ; 4  undefined
0469 D995 AF D9                 DC W:DoIfWants                 ; 5  auto key down
0470 D997 EB D9                 DC W:DoUpdate                  ; 6  update
0471 D999 AB D9                 DC W:Ignore                    ; 7  undefined
0472 D99B EB D9                 DC W:DoActivate                ; 8  activate
0473 D99D AB D9                 DC W:Ignore                    ; 9  switch event
0474 D99F AB D9                 DC W:Ignore                    ; 10 desk acc
0475 D9A1 AB D9                 DC W:Ignore                    ; 11 device driver
0476 D9A3 AB D9                 DC W:Ignore                    ; 12 Ap
0477 D9A5 AB D9                 DC W:Ignore                    ; 13
0478 D9A7 AB D9                 DC W:Ignore                    ; 14
0479 D9A9 AB D9                 DC W:Ignore                    ; 15
0480 D9AB
0481 D9AB
0482 D9AB              ;-------------------------------------------------
0483 D9AB              ;
0484 D9AB              ; Equates for direct page after the startNDACall
0485 D9AB              ; is made.
0486 D9AB              ; 
0487 D9AB                       DSect OrigDirect+2 
0488 D9AB              rtsadr   word 
0489 D9AB              xOrigD   word 
0490 D9AB              xDAPtr   long 
0491 D9AB              xDAHandle long 
0492 D9AB              xret1    block 3
0493 D9AB              xret2    block 3
0494 D9AB              Dwhat    word 
0495 D9AB              Dmessage long 
0496 D9AB              Dwhen    long 
0497 D9AB              Dwhere   long 
0498 D9AB              Dmods    word 
0499 D9AB              Dresult  word 
0500 D9AB
0501 D9AB
0502 D9AB A9 00 00     Ignore   lda   #0
0503 D9AE 60                    rts   
0504 D9AF
0505 D9AF A5 07        DoIfWants lda   DAHandle
0506 D9B1 A4 09                 ldy   DAHandle+2
0507 D9B3
0508 D9B3 20 9A E0              jsr   StartNDACall
0509 D9B6 20 A1 DF              jsr   DerefNDAList
0510 D9B9
0511 D9B9 20 17 E0              jsr   AreWeTop
0512 D9BC 90 0F                 bcc   No
0513 D9BE              DIW0010   
0514 D9BE A5 2D                 lda   Dwhat
0515 D9C0 0A                    asl   a
0516 D9C1 AA                    tax   
0517 D9C2 BF D7 D9 FE           lda   >MaskTable,x
0518 D9C6 A0 14 00              ldy   #o_EventMask
0519 D9C9 37 09                 and   [PtrToThisOne],y
0520 D9CB D0 31                 bne   SendItOn
0521 D9CD
0522 D9CD
0523 D9CD 20 B6 DF     No       jsr   UnlockNDAList
0524 D9D0 20 AE E0              jsr   EndNDACall
0525 D9D3
0526 D9D3 A9 00 00              lda   #0
0527 D9D6 60                    rts   
0528 D9D7
0529 D9D7
0530 D9D7              ;----------------------------------------------------
0531 D9D7              ;
0532 D9D7              ; events greater than 9 are not passed on.
0533 D9D7              ;
0534 D9D7 01 00        MaskTable DC W:%0000000000000001        ; 0
0535 D9D9 02 00                 DC W:%0000000000000010         ; 1
0536 D9DB 04 00                 DC W:%0000000000000100         ; 2
0537 D9DD 08 00                 DC W:%0000000000001000         ; 3
0538 D9DF 10 00                 DC W:%0000000000010000         ; 4
0539 D9E1 20 00                 DC W:%0000000000100000         ; 5
0540 D9E3 40 00                 DC W:%0000000001000000         ; 6
0541 D9E5 80 00                 DC W:%0000000010000000         ; 7
0542 D9E7 00 01                 DC W:%0000000100000000         ; 8
0543 D9E9 00 02                 DC W:%0000001000000000         ; 9
0544 D9EB
0545 D9EB              DoActivate                              ; 
0546 D9EB              DoUpdate                                ; 
0547 D9EB A5 07                 lda   DAHandle                 ; set a and y registers before
0548 D9ED A4 09                 ldy   DAHandle+2               ; calling StartNDACall
0549 D9EF 20 9A E0              jsr   StartNDACall
0550 D9F2 20 A1 DF              jsr   DerefNDAList
0551 D9F5
0552 D9F5 A5 2F                 lda   DMessage
0553 D9F7 A6 31                 ldx   DMessage+2
0554 D9F9 20 CD DF              jsr   FindThisWindow
0555 D9FC 90 CF                 bcc   No
0556 D9FE
0557 D9FE
0558 D9FE 20 22 E0     SendItOn jsr   SetResID
0559 DA01
0560 DA01 7B                    tdc   
0561 DA02 18                    clc   
0562 DA03 69 2D 00              adc   #DWhat
0563 DA06 AA                    tax   
0564 DA07 A0 00 00              ldy   #0
0565 DA0A A9 01 00              lda   #DAEventCode
0566 DA0D 22 91 E0 FE           jsl   SendAction
0567 DA11
0568 DA11 20 4D E0              jsr   RepResID
0569 DA14
0570 DA14
0571 DA14 20 B6 DF              jsr   UnlockNDAList
0572 DA17 20 AE E0              jsr   EndNDACall
0573 DA1A
0574 DA1A A9 00 80              lda   #$8000
0575 DA1D 60                    rts   
0576 DA1E
0577 DA1E
0578 DA1E                       ENDP 
0579 DA1E
0580 DA1E
0581 DA1E              ****************************************************************
0582 DA1E              *
0583 DA1E              * CallCDAMenu
0584 DA1E              *
0585 DA1E              * This routine is almost identical to the daHandle routine
0586 DA1E              * in rom except that we know that we did not get here from
0587 DA1E              * an interrupt so interrupt processing code was removed.
0588 DA1E              *
0589 DA1E              * Also, since this is called through system event, we know
0590 DA1E              * that there is no need for scheduling.
0591 DA1E              *
0592 DA1E              * This routine is called in full native mode (the routine
0593 DA1E              * in rom was called in 8 bit mode).
0594 DA1E              *
0595 DA1E              * There is no information returned by this routine.
0596 DA1E              *
0597 DA1E              * Change History
0598 DA1E              *
0599 DA1E              * 01 Oct 87             Steven Glass
0600 DA1E              *
0601 DA1E              * This routine used in-line storage to preserve the data
0602 DA1E              * bank.  It now uses the stack.
0603 DA1E              *
0604 DA1E              ****************************************************************
0605 DA1E              CallCDAMenu PROC EXPORT 
0606 DA1E
0607 DA1E 8B                    phb                            ; save dbr on stack before anything happens
0608 DA1F
0609 DA1F 3B                    tsc                            ; save stack for integer basic
0610 DA20 8F 9C 1D E0           sta   >stacksv
0611 DA24
0612 DA24 8B                    phb                            ; stack is saved as $E0/0300
0613 DA25 A2 00 01              ldx   #$0100
0614 DA28 A0 00 03              ldy   #$0300
0615 DA2B A9 FF 00              lda   #$FF
0616 DA2E 54 E0 00              mvn   $000000,$E00000
0617 DA31
0618 DA31 AB                    plb   
0619 DA32
0620 DA32 A9 FB 01              lda   #$1FB                    ; make sure there's room on stack
0621 DA35 1B                    tcs   
0622 DA36
0623 DA36 A2 05 0B 22           _saveall                       ; save everything
0624 DA3D A2 05 11 22           _choosecda                     ; display the list of da's
0625 DA44 A2 05 0C 22           _restall                       ; unsave everything
0626 DA4B
0627 DA4B              ;               phb		 	; restore stack (but save b)
0628 DA4B              ;               phb
0629 DA4B              ;               pla
0630 DA4B              ;               sta	     >LocalBRegSave
0631 DA4B
0632 DA4B A2 00 03              ldx   #$0300
0633 DA4E A0 00 01              ldy   #$0100
0634 DA51 A9 FF 00              lda   #$FF
0635 DA54 54 00 E0              mvn   $E00000,$000000
0636 DA57
0637 DA57 AF 9C 1D E0           lda   >stacksv
0638 DA5B 1B                    tcs   
0639 DA5C
0640 DA5C              ;               lda	     >LocalBRegSave
0641 DA5C              ;               pha
0642 DA5C              ;               plb
0643 DA5C              ;               plb
0644 DA5C
0645 DA5C AB                    plb                            ; restore dbr saved first thing.
0646 DA5D
0647 DA5D 6B                    rtl   
0648 DA5E
0649 DA5E              ;LocalBRegSave  ds 2
0650 DA5E
0651 DA5E
0652 DA5E                       ENDP 
0653 DA5E
0654 DA5E
0655 DA5E
0656 DA5E
0657 DA5E              ****************************************************************
0658 DA5E              *
0659 DA5E              * InstallNDA
0660 DA5E              *
0661 DA5E              *           HandleToNDA
0662 DA5E              *
0663 DA5E              * This is the routine we use to install a new da in the system.
0664 DA5E              * We pass a handle to this call (rather than a pointer) because
0665 DA5E              * InstallCDA uses a handle.  (InstallCDA used a handle by
0666 DA5E              * accident and we regret it but there is nothing we can do.)
0667 DA5E              *
0668 DA5E              * This call makes a new entry in the NDAList for the NDA.  This
0669 DA5E              * entry contains most of the information in the NDA header.
0670 DA5E              *
0671 DA5E              * Change History
0672 DA5E              *
0673 DA5E              * 02 Oct 87             Steven Glass
0674 DA5E              *
0675 DA5E              * Changes were made here to use the new structure of the 
0676 DA5E              * NDAGlobals record.
0677 DA5E              *
0678 DA5E              *
0679 DA5E              ****************************************************************
0680 DA5E              InstallNDA PROC EXPORT 
0681 DA5E
0682 DA5E                       DSect OrigDirect+2 
0683 DA5E              Rtl1     block 3 
0684 DA5E              RTL2     block 3 
0685 DA5E              UserHandle long 
0686 DA5E
0687 DA5E
0688 DA5E 20 9A E0              jsr   StartNDACall
0689 DA61 20 A1 DF              jsr   DerefNDAList
0690 DA64
0691 DA64 A7 01                 lda   [NDAListPtr]             ; get the num entries
0692 DA66
0693 DA66 1A                    inc   a
0694 DA67
0695 DA67 48                    pha                            ; space for result
0696 DA68 48                    pha   
0697 DA69 48                    pha                            ; Num entries after adding one
0698 DA6A F4 24 00              PushWord #NDARecSize           ; Size of a NDArecord
0699 DA6D A2 0B 09 22           _Multiply 
0700 DA74
0701 DA74 A3 01                 lda   1,s                      ; add result to 2 to get new size
0702 DA76 18                    clc   
0703 DA77 69 0E 00              adc   #SizeOfDeskGlobals
0704 DA7A 83 01                 sta   1,s
0705 DA7C 90 05                 bcc   SizeIsAdjusted
0706 DA7E A3 03                 lda   3,s
0707 DA80 1A                    inc   a
0708 DA81 83 03                 sta   3,s
0709 DA83
0710 DA83 A3 01        SizeIsAdjusted lda   1,s                ; now calculate where new rec will
0711 DA85 38                    sec   
0712 DA86 E9 24 00              sbc   #NDARecSize
0713 DA89 85 05                 sta   OffsetToThisOne
0714 DA8B A3 03                 lda   3,s
0715 DA8D E9 00 00              sbc   #0
0716 DA90 85 07                 sta   OffsetToThisOne+2
0717 DA92
0718 DA92 20 B6 DF              jsr   UnlockNDAList
0719 DA95
0720 DA95 D4 17                 pei   NDAListHandle+2
0721 DA97 D4 15                 pei   NDAListHandle
0722 DA99 A2 02 19 22           _SetHandleSize 
0723 DAA0 B0 77                 bcs   ERROR
0724 DAA2
0725 DAA2
0726 DAA2 20 A1 DF              jsr   DerefNDAList
0727 DAA5
0728 DAA5              ;----------------------------------------------------
0729 DAA5              ;
0730 DAA5              ; Bump the NDA list count.
0731 DAA5              ;
0732 DAA5 A7 01                 lda   [NDAListPtr]
0733 DAA7 1A                    inc   a
0734 DAA8 87 01                 sta   [NDAListPtr]
0735 DAAA
0736 DAAA A5 01                 lda   NDAListPtr
0737 DAAC 18                    clc   
0738 DAAD 65 05                 adc   OffsetToThisOne
0739 DAAF 85 09                 sta   PtrToThisOne
0740 DAB1 A5 03                 lda   NDAListPtr+2
0741 DAB3 65 07                 adc   OffsetToThisOne+2
0742 DAB5 85 0B                 sta   PtrToThisOne+2
0743 DAB7
0744 DAB7 A5 21 85 0D           movelong userhandle,NDAHandle 
0745 DABF 20 C1 DF              jsr   DerefNDAHandle
0746 DAC2
0747 DAC2 A9 00 00              lda   #0                       ; zero the status flags (first
0748 DAC5 87 09                 sta   [PtrToThisOne]           ; word of NDA record)
0749 DAC7
0750 DAC7              ;----------------------------------------------------
0751 DAC7              ;
0752 DAC7              ; Move 20 bytes of info from the da to the table.
0753 DAC7              ; The NDA offsets are 2 less than the table offsets.
0754 DAC7              ;
0755 DAC7 A0 00 00              ldy   #0
0756 DACA B7 11        Loop     lda   [NDAPtr],y
0757 DACC C8                    iny   
0758 DACD C8                    iny   
0759 DACE 97 09                 sta   [PtrToThisOne],y
0760 DAD0 C0 14 00              cpy   #20
0761 DAD3 90 F5                 bcc   Loop
0762 DAD5
0763 DAD5 A0 1A 00              ldy   #o_WindowPtr             ; zero the window ptr
0764 DAD8 A9 00 00              lda   #0
0765 DADB 97 09                 sta   [PtrToThisOne],y
0766 DADD C8                    iny   
0767 DADE C8                    iny   
0768 DADF 97 09                 sta   [PtrToThisOne],y
0769 DAE1
0770 DAE1 A0 1E 00              ldy   #o_Handle
0771 DAE4 A5 21                 lda   UserHandle
0772 DAE6 97 09                 sta   [PtrToThisOne],y
0773 DAE8 C8                    iny   
0774 DAE9 C8                    iny   
0775 DAEA A5 23                 lda   UserHandle+2
0776 DAEC 97 09                 sta   [PtrToThisOne],y
0777 DAEE
0778 DAEE              ;
0779 DAEE              ; Find the UserID of the handle
0780 DAEE              ;
0781 DAEE A0 06 00              ldy   #6                       	; user id is 6 bytes into handle
0782 DAF1 B7 21                 lda   [UserHandle],y
0783 DAF3 48                    pha                            ; save on stack while
0784 DAF4 D4 23                 pei   UserHandle+2             	; validating the handle.
0785 DAF6 D4 21                 pei   UserHandle
0786 DAF8 A2 02 1E 22           _CheckHandle 
0787 DAFF 90 05                 bcc   ValidHandle              	; handle was valid
0788 DB01
0789 DB01 A9 00 00              lda   #0                       	; handle was not valid, use 0
0790 DB04 83 01                 sta   1,s
0791 DB06
0792 DB06              ValidHandle                             ; put the id into the record
0793 DB06 68                    pla   
0794 DB07 A0 22 00              ldy   #o_UserID
0795 DB0A 97 09                 sta   [PtrToThisOne],y
0796 DB0C
0797 DB0C
0798 DB0C 20 B6 DF              jsr   UnlockNDAList
0799 DB0F
0800 DB0F A2 00 00              ldx   #0
0801 DB12
0802 DB12 20 AE E0     GetOut   jsr   EndNDACall
0803 DB15 5C 12 FC FE           jml   oErrOut4
0804 DB19
0805 DB19
0806 DB19 AA           Error    tax   
0807 DB1A 80 F6                 bra   GetOut
0808 DB1C
0809 DB1C                       ENDP 
0810 DB1C
0811 DB1C
0812 DB1C
0813 DB1C              ****************************************************************
0814 DB1C              *
0815 DB1C              * OpenNDA
0816 DB1C              *
0817 DB1C              *     Input     ID : word
0818 DB1C              *     Output    Refnum
0819 DB1C              *
0820 DB1C              *
0821 DB1C              * Stack looks like:
0822 DB1C              *
0823 DB1C              *      Space For Output
0824 DB1C              *      ID of NDA to open
0825 DB1C              *      =================
0826 DB1C              *                         <- SP
0827 DB1C              *
0828 DB1C              *
0829 DB1C              * The menu manager reserves menu item IDs 1 to 255 for
0830 DB1C              * the system.  I use 1 through NumNDAs for the IDs of
0831 DB1C              * desk accessories.  When an application wants to open
0832 DB1C              * an NDA, it just calls OpenNDA with the item ID returned
0833 DB1C              * from the menu manager.
0834 DB1C              *
0835 DB1C              * Change History
0836 DB1C              *
0837 DB1C              * 02 Oct 87             Steven Glass
0838 DB1C              *
0839 DB1C              * Changes were made here to use the new structure of the 
0840 DB1C              * NDAGlobals record.
0841 DB1C              *
0842 DB1C              * In addition, I changed the error exit and normal exit
0843 DB1C              * routines to share code.
0844 DB1C              *
0845 DB1C              *
0846 DB1C              * 16 Jun 88         Steven Glass
0847 DB1C              *
0848 DB1C              * If the NDA returns a NIL window pointer I do not mark it as 
0849 DB1C              * being open.  This allows DAs to be modal dialogs and 
0850 DB1C              * not be tricky when trying to close.
0851 DB1C              *
0852 DB1C              ****************************************************************
0853 DB1C              OpenNDA  PROC EXPORT 
0854 DB1C
0855 DB1C                       DSect OrigDirect+2 
0856 DB1C              RTL1     block 3 
0857 DB1C              RTL2     block 3 
0858 DB1C              ID       word 
0859 DB1C              Result   word 
0860 DB1C
0861 DB1C 20 9A E0              jsr   StartNDACall
0862 DB1F
0863 DB1F 20 A1 DF              jsr   DerefNDAList
0864 DB22
0865 DB22 A5 21                 lda   ID
0866 DB24 3A                    dec   a
0867 DB25 C7 01                 cmp   [NDAListPtr]
0868 DB27 90 03                 bcc   @GotIt
0869 DB29 82 86 00              brl   NotFound
0870 DB2C
0871 DB2C 48           @GotIt   pha                            ; space for result
0872 DB2D 48                    pha                            ; (2 words)
0873 DB2E 48                    pha                            ; one less the id of this one
0874 DB2F F4 24 00              PushWord #NDARecSize 
0875 DB32 A2 0B 09 22           _Multiply 
0876 DB39
0877 DB39 68                    pla                            ; take result of multply and
0878 DB3A FA                    plx                            ; add in the size of the globals
0879 DB3B 18                    clc                            ; at the beginning of the handle.
0880 DB3C 69 0E 00              adc   #SizeOfDeskGlobals
0881 DB3F
0882 DB3F 85 23                 sta   Result                   ; use this result as the ref num
0883 DB41
0884 DB41
0885 DB41              ;----------------------------------------------------
0886 DB41              ;
0887 DB41              ; Fix the PtrToThisOne variable using offset just
0888 DB41              ; calculated.
0889 DB41              ;
0890 DB41 18                    clc   
0891 DB42 65 01                 adc   NDAListPTr
0892 DB44 85 09                 sta   PtrToThisOne
0893 DB46 A5 03                 lda   NDAListPtr+2
0894 DB48 90 01                 bcc   NoCarry
0895 DB4A 1A                    inc   a
0896 DB4B 85 0B        NoCarry  sta   PtrToThisOne+2
0897 DB4D
0898 DB4D A7 09                 lda   [PtrToThisOne]           ; look at status flags
0899 DB4F F0 14                 beq   OpenIt                   ; if zero then not open yet
0900 DB51
0901 DB51              ;----------------------------------------------------
0902 DB51              ;
0903 DB51              ; The DA is already open, so we go and select it.
0904 DB51              ;
0905 DB51
0906 DB51 A0 1C 00              ldy   #o_WindowPtr+2
0907 DB54 B7 09                 lda   [PtrToThisOne],y
0908 DB56 48                    pha   
0909 DB57 88                    dey   
0910 DB58 88                    dey   
0911 DB59 B7 09                 lda   [PtrToThisOne],y
0912 DB5B 48                    pha   
0913 DB5C A2 0E 11 22           _SelectWindow 
0914 DB63 80 3E        @handled bra   AllDone
0915 DB65
0916 DB65              ;----------------------------------------------------
0917 DB65              ;
0918 DB65              ; The DA is not open, so we get it opened.
0919 DB65              ;
0920 DB65 20 22 E0     OpenIt   jsr   SetResID
0921 DB68
0922 DB68 F4 00 00 F4           PushLong #0                    ; put room on stack
0923 DB6E 22 6B E0 FE           jsl   SendOpen                 ; call the open routine
0924 DB72
0925 DB72 A3 01                 lda   1,s                      ; if pointer is zero, do nothing more.
0926 DB74 03 03                 ora   3,s
0927 DB76 D0 04                 bne   @1
0928 DB78 68                    pla   
0929 DB79 68                    pla   
0930 DB7A 80 24                 bra   NoWindow
0931 DB7C              @1        
0932 DB7C
0933 DB7C A0 1A 00              ldy   #o_WindowPtr             ; put result in windowPtr field
0934 DB7F 68                    pla   
0935 DB80 97 09                 sta   [PtrToThisOne],y
0936 DB82 C8                    iny   
0937 DB83 C8                    iny   
0938 DB84 68                    pla   
0939 DB85 97 09                 sta   [PtrToThisOne],y
0940 DB87
0941 DB87 A9 00 80              lda   #$8000                   ; make status word indicate this is
0942 DB8A 87 09                 sta   [PtrToThisOne]           ; open.
0943 DB8C
0944 DB8C 48                    pha                            ; Init the last serviced field 
0945 DB8D 48                    pha   
0946 DB8E A2 03 25 22           _GetTick 
0947 DB95 A0 16 00              ldy   #o_LastServiced
0948 DB98 68                    pla   
0949 DB99 97 09                 sta   [PtrToThisOne],y
0950 DB9B C8                    iny   
0951 DB9C C8                    iny   
0952 DB9D 68                    pla   
0953 DB9E 97 09                 sta   [PtrToThisOne],y
0954 DBA0
0955 DBA0              NoWindow  
0956 DBA0 20 4D E0              jsr   RepResID
0957 DBA3
0958 DBA3              ;----------------------------------------------------
0959 DBA3              ;
0960 DBA3              ; All done, so clean up.
0961 DBA3
0962 DBA3 A2 00 00     AllDone  ldx   #0
0963 DBA6 DA           JoinExit phx   
0964 DBA7 20 B6 DF              jsr   UnlockNDAList
0965 DBAA FA                    plx   
0966 DBAB 20 AE E0              jsr   EndNDACall
0967 DBAE
0968 DBAE 5C FC FB FE           jml   oErrOut2
0969 DBB2
0970 DBB2 A2 10 05     NotFound ldx   #DANotFound
0971 DBB5 80 EF                 bra   JoinExit
0972 DBB7
0973 DBB7
0974 DBB7                       ENDP 
0975 DBB7
0976 DBB7
0977 DBB7
0978 DBB7              ****************************************************************
0979 DBB7              *
0980 DBB7              * CloseNDA
0981 DBB7              *
0982 DBB7              *     Input     Refnum
0983 DBB7              *
0984 DBB7              *
0985 DBB7              * Stack looks like:
0986 DBB7              *
0987 DBB7              *      Refnum
0988 DBB7              *      =================
0989 DBB7              *	      <- SP
0990 DBB7              *
0991 DBB7              *
0992 DBB7              * Change History
0993 DBB7              *
0994 DBB7              * 02 Oct 87	    Steven Glass
0995 DBB7              *
0996 DBB7              * No changes were needed here to use the new structure of the 
0997 DBB7              * NDAGlobals record.
0998 DBB7              *
0999 DBB7              *
1000 DBB7              ****************************************************************
1001 DBB7              CloseNDA PROC EXPORT 
1002 DBB7
1003 DBB7                       DSect OrigDirect+2 
1004 DBB7              RTL1     block 3 
1005 DBB7              RTL2     block 3 
1006 DBB7              RefNum   word 
1007 DBB7
1008 DBB7 20 9A E0              jsr   StartNDACall
1009 DBBA
1010 DBBA 20 A1 DF              jsr   DerefNDAList
1011 DBBD
1012 DBBD A5 01                 lda   NDAListPtr
1013 DBBF 18                    clc   
1014 DBC0 65 21                 adc   RefNum
1015 DBC2 85 09                 sta   PtrToThisOne
1016 DBC4 A5 03                 lda   NDAListPtr+2
1017 DBC6 90 01                 bcc   NoCarry
1018 DBC8 1A                    inc   a
1019 DBC9 85 0B        NoCarry  sta   PtrToThisOne+2
1020 DBCB
1021 DBCB A7 09                 lda   [PtrToThisOne]
1022 DBCD F0 03                 beq   NeverMind
1023 DBCF
1024 DBCF 20 45 DC              jsr   DoCloseStuff
1025 DBD2
1026 DBD2 20 B6 DF     NeverMind jsr   UnlockNDAList
1027 DBD5
1028 DBD5 20 AE E0              jsr   EndNDACall
1029 DBD8
1030 DBD8 5C F7 FB FE           jml   oEndCall2
1031 DBDC
1032 DBDC                       ENDP 
1033 DBDC
1034 DBDC
1035 DBDC              ****************************************************************
1036 DBDC              *
1037 DBDC              * CloseNDAbyWinPtr
1038 DBDC              *
1039 DBDC              *     Input     WinPtr
1040 DBDC              *
1041 DBDC              *
1042 DBDC              * Stack looks like:
1043 DBDC              *
1044 DBDC              *      WinPtr
1045 DBDC              *      =================
1046 DBDC              *                         <- SP
1047 DBDC              *
1048 DBDC              *
1049 DBDC              *
1050 DBDC              * Change History
1051 DBDC              *
1052 DBDC              * 02 Oct 87             Steven Glass
1053 DBDC              *
1054 DBDC              * No changes were needed here to use the new structure of the 
1055 DBDC              * NDAGlobals record.
1056 DBDC              *
1057 DBDC              * However, I changed the error exit and normal exit
1058 DBDC              * routines to share code.
1059 DBDC              *
1060 DBDC              ****************************************************************
1061 DBDC              CloseNDAbyWinPtr PROC EXPORT 
1062 DBDC
1063 DBDC                       DSect OrigDirect+2 
1064 DBDC              RTL1     block 3 
1065 DBDC              RTL2     block 3 
1066 DBDC              WinPtr   long 
1067 DBDC
1068 DBDC 20 9A E0              jsr   StartNDACall
1069 DBDF 20 A1 DF              jsr   DerefNDAList
1070 DBE2
1071 DBE2 A5 21                 lda   WinPtr
1072 DBE4 A6 23                 ldx   WinPtr+2
1073 DBE6 20 CD DF              jsr   FindThisWindow
1074 DBE9 90 12                 bcc   CannotFind
1075 DBEB
1076 DBEB 20 45 DC              jsr   DoCloseStuff
1077 DBEE
1078 DBEE A2 00 00              ldx   #0
1079 DBF1 DA           JoinExit phx   
1080 DBF2 20 B6 DF              jsr   UnlockNDAList
1081 DBF5 FA                    plx   
1082 DBF6 20 AE E0              jsr   EndNDACall
1083 DBF9
1084 DBF9 5C 12 FC FE           jml   oErrOut4
1085 DBFD
1086 DBFD A2 11 05     CannotFind ldx   #NotSysWindow
1087 DC00 80 EF                 bra   JoinExit
1088 DC02
1089 DC02                       ENDP 
1090 DC02
1091 DC02
1092 DC02              ****************************************************************
1093 DC02              *
1094 DC02              * CloseAllNDAs
1095 DC02              *
1096 DC02              *     Input     none
1097 DC02              *
1098 DC02              *
1099 DC02              * Change History
1100 DC02              *
1101 DC02              * 02 Oct 87             Steven Glass
1102 DC02              *
1103 DC02              * No changes were needed here to use the new structure of the 
1104 DC02              * NDAGlobals record.
1105 DC02              *
1106 DC02              * However, I changed the code to use the stack to hold a counter
1107 DC02              * instead of storage in line.
1108 DC02              *
1109 DC02              ****************************************************************
1110 DC02              CloseAllNDAs2 PROC EXPORT 
1111 DC02
1112 DC02 20 9A E0              jsr   StartNDACall
1113 DC05 20 A1 DF              jsr   DerefNDAList
1114 DC08
1115 DC08 F4 00 00              PushWord #0                    ; init counter on stack
1116 DC0B
1117 DC0B A5 01                 lda   NDAListPtr
1118 DC0D 18                    clc   
1119 DC0E 69 0E 00              adc   #SizeOfDeskGlobals
1120 DC11 85 09                 sta   PtrToThisOne
1121 DC13 A5 03                 lda   NDAListPtr+2
1122 DC15 90 01                 bcc   NoCarry1
1123 DC17 1A                    inc   a
1124 DC18 85 0B        NoCarry1 sta   PtrToThisOne+2
1125 DC1A
1126 DC1A A3 01        Loop     lda   1,s
1127 DC1C C7 01                 cmp   [NDAListPtr]
1128 DC1E B0 1A                 bcs   AllDone
1129 DC20
1130 DC20 A7 09                 lda   [PtrToThisOne]
1131 DC22 F0 03                 beq   NotOpen
1132 DC24
1133 DC24 20 45 DC              jsr   DoCloseStuff
1134 DC27
1135 DC27 A5 09        NotOpen  lda   PtrToThisOne
1136 DC29 18                    clc   
1137 DC2A 69 24 00              adc   #NDARecSize
1138 DC2D 85 09                 sta   PtrToThisOne
1139 DC2F 90 02                 bcc   NoCarry2
1140 DC31 E6 0B                 inc   PtrToThisOne+2
1141 DC33              NoCarry2  
1142 DC33 A3 01                 lda   1,s
1143 DC35 1A                    inc   a
1144 DC36 83 01                 sta   1,s
1145 DC38 80 E0                 bra   Loop
1146 DC3A
1147 DC3A 68           AllDone  pla                            ; clean off the stack
1148 DC3B 20 B6 DF              jsr   UnlockNDAList
1149 DC3E 20 AE E0              jsr   EndNDACall
1150 DC41 5C DF FB FE           jml   oEndCall0
1151 DC45
1152 DC45                       ENDP 
1153 DC45
1154 DC45
1155 DC45              ****************************************************************
1156 DC45              *
1157 DC45              * DoCloseStuff
1158 DC45              *
1159 DC45              * This is a routine that is shared by CloseNDA and
1160 DC45              * by SystemClick for close the NDAs.
1161 DC45              *
1162 DC45              *
1163 DC45              * Change History
1164 DC45              *
1165 DC45              * 02 Oct 87             Steven Glass
1166 DC45              *
1167 DC45              * No changes required to support new data structures.
1168 DC45              *
1169 DC45              ****************************************************************
1170 DC45              DoCloseStuff PROC EXPORT 
1171 DC45 20 22 E0              jsr   SetResID
1172 DC48
1173 DC48 22 7F E0 FE           jsl   SendClose
1174 DC4C
1175 DC4C 20 4D E0              jsr   RepResID
1176 DC4F
1177 DC4F A0 1A 00              ldy   #o_WindowPtr
1178 DC52 A9 00 00              lda   #0
1179 DC55 97 09                 sta   [PtrToThisOne],y
1180 DC57 C8                    iny   
1181 DC58 C8                    iny   
1182 DC59 97 09                 sta   [PtrToThisOne],y
1183 DC5B
1184 DC5B A9 00 00              lda   #0                       ; the the status word
1185 DC5E 87 09                 sta   [PtrToThisOne]
1186 DC60
1187 DC60 60                    rts   
1188 DC61
1189 DC61                       ENDP 
1190 DC61
1191 DC61
1192 DC61
1193 DC61              ****************************************************************
1194 DC61              *
1195 DC61              * SystemTask
1196 DC61              *
1197 DC61              * This is the routine that an application must call
1198 DC61              * periodically to keep desk accessories alive.  The suggestion
1199 DC61              * is that applications call this routine every time through
1200 DC61              * the main event loop.
1201 DC61              *
1202 DC61              * This routine also makes the CURSOR calls to the da that
1203 DC61              * is the front window.
1204 DC61              *
1205 DC61              * Change History
1206 DC61              *
1207 DC61              * 02 Oct 87             Steven Glass
1208 DC61              *
1209 DC61              * Changes were made here to use the new structure of the 
1210 DC61              * NDAGlobals record.
1211 DC61              *
1212 DC61              * Additionally, the code that reads the tick count was changed
1213 DC61              * do turn interrupts off (rather than turning them on) while
1214 DC61              * the two words are read.  (The code did a cli rather than
1215 DC61              * an sei.)
1216 DC61              *
1217 DC61              ****************************************************************
1218 DC61              SystemTask PROC EXPORT 
1219 DC61
1220 DC61              TickCount equ   OffsetToThisOne         ; zp aliasing
1221 DC61
1222 DC61 20 9A E0              jsr   StartNDACall             ;inc busy flag
1223 DC64 20 A1 DF              jsr   DerefNDAList             ;deref and lock handle to NDAListPtr
1224 DC67
1225 DC67              ;------------------------------------------------------
1226 DC67              ;
1227 DC67              ; first send cursor message if the front window is
1228 DC67              ; one of our windows.
1229 DC67              ;
1230 DC67 20 17 E0              jsr   AreWeTop                 ;is top window a system window?
1231 DC6A 90 0D                 bcc   NotOnTop
1232 DC6C
1233 DC6C 20 22 E0              jsr   SetResID
1234 DC6F
1235 DC6F A9 03 00              lda   #DACursorCode
1236 DC72 22 91 E0 FE           jsl   SendAction
1237 DC76
1238 DC76 20 4D E0              jsr   RepResID
1239 DC79              ;------------------------------------------------------
1240 DC79              ;
1241 DC79              ; Now go through the list of open DA's and see if
1242 DC79              ; any need periodic wake ups
1243 DC79
1244 DC79              NotOnTop                                ; 
1245 DC79 A0 06 00              ldy   #o_TickAddress           ; put the address of the tick
1246 DC7C B7 01                 lda   [NDAListPtr],y           ; count on direct page.
1247 DC7E 85 11                 sta   NDAPtr
1248 DC80 C8                    iny   
1249 DC81 C8                    iny   
1250 DC82 B7 01                 lda   [NDAListPtr],y
1251 DC84 85 13                 sta   NDAPtr+2
1252 DC86
1253 DC86 08                    php                            ; ints off while accessing
1254 DC87 78                    sei   
1255 DC88 A7 11                 lda   [NDAPtr]
1256 DC8A 85 05                 sta   TickCount
1257 DC8C A0 02 00              ldy   #2
1258 DC8F B7 11                 lda   [NDAPtr],y
1259 DC91 85 07                 sta   TickCount+2
1260 DC93 28                    plp                            ; restore ints
1261 DC94
1262 DC94 A5 01                 lda   NDAListPtr               ; initialize PtrToThisOne
1263 DC96 18                    clc   
1264 DC97 69 0E 00              adc   #SizeOfDeskGlobals
1265 DC9A 85 09                 sta   PtrToThisOne
1266 DC9C A5 03                 lda   NDAListPtr+2
1267 DC9E 69 00 00              adc   #0
1268 DCA1 85 0B                 sta   PtrToThisOne+2
1269 DCA3
1270 DCA3 F4 00 00              pea   0                        ; put counter on stack
1271 DCA6
1272 DCA6 A3 01        Loop     lda   1,s                      ; is counter greater or equal num das
1273 DCA8 C7 01                 cmp   [NDAListPtr]
1274 DCAA B0 58                 bcs   NDAsDone
1275 DCAC
1276 DCAC A7 09                 lda   [PtrToThisOne]           ; see if it is open
1277 DCAE F0 43                 beq   NotThisOne
1278 DCB0
1279 DCB0
1280 DCB0 A0 12 00              ldy   #o_Period                ; if period is $FFFF then it
1281 DCB3 B7 09                 lda   [PtrToThisOne],y         ; does not want this shit
1282 DCB5 C9 FF FF              cmp   #$FFFF
1283 DCB8 F0 39                 beq   NotThisOne
1284 DCBA
1285 DCBA              ;------------------------------------------------------
1286 DCBA              ;
1287 DCBA              ; Calculate how many ticks since last service.
1288 DCBA              ;
1289 DCBA              ;    TickCount - LastServiced
1290 DCBA              ;
1291 DCBA              ; If result is negative, invert it (very unlikely since
1292 DCBA              ; it takes two years of constant running for the tick
1293 DCBA              ; count to wrap.
1294 DCBA              ;
1295 DCBA A5 05                 lda   TickCount
1296 DCBC 38                    sec   
1297 DCBD A0 16 00              ldy   #o_LastServiced
1298 DCC0 F7 09                 sbc   [PtrToThisOne],y
1299 DCC2 AA                    tax                            ; put result in x
1300 DCC3 C8                    iny                            ; do rest of divide
1301 DCC4 C8                    iny   
1302 DCC5 A5 07                 lda   TickCount+2
1303 DCC7 F7 09                 sbc   [PtrToThisOne],y
1304 DCC9 10 06                 bpl   IsPos                    ; if this is pos then it is 0
1305 DCCB 8A                    txa                            ; if neg then we wrapped.
1306 DCCC 49 FF FF              eor   #$FFFF
1307 DCCF 1A                    inc   a
1308 DCD0 AA                    tax   
1309 DCD1 8A           IsPos    txa                            ; get back from x and see
1310 DCD2 A0 12 00              ldy   #o_Period                ; if this is greater than
1311 DCD5 D7 09                 cmp   [PtrToThisOne],y         ; period
1312 DCD7 90 1A                 bcc   NotThisOne
1313 DCD9
1314 DCD9              ;------------------------------------------------------
1315 DCD9              ;
1316 DCD9              ; It is greater than period so save new value for
1317 DCD9              ; last serviced.
1318 DCD9              ;
1319 DCD9 A0 16 00              ldy   #o_LastServiced          ; fix last serviced field in rec
1320 DCDC A5 05                 lda   TickCount
1321 DCDE 97 09                 sta   [PtrToThisOne],y
1322 DCE0 C8                    iny   
1323 DCE1 C8                    iny   
1324 DCE2 A5 07                 lda   TickCount+2
1325 DCE4 97 09                 sta   [PtrToThisOne],y
1326 DCE6
1327 DCE6 20 22 E0              jsr   SetResID
1328 DCE9
1329 DCE9 A9 02 00              lda   #DARunCode               ; send the run code to NDA
1330 DCEC 22 91 E0 FE           jsl   SendAction
1331 DCF0
1332 DCF0 20 4D E0              jsr   RepResID
1333 DCF3
1334 DCF3 A5 09        NotThisOne lda   PtrToThisOne           ; now bump pointer to current da
1335 DCF5 18                    clc   
1336 DCF6 69 24 00              adc   #NDARecSize
1337 DCF9 85 09                 sta   PtrToThisOne
1338 DCFB 90 02                 bcc   NoCarry2
1339 DCFD E6 0B                 inc   PtrToThisOne+2
1340 DCFF 68           NoCarry2 pla                            ; bump counter on stack
1341 DD00 1A                    inc   a
1342 DD01 48                    pha   
1343 DD02 80 A2                 bra   Loop
1344 DD04
1345 DD04 68           NDAsDone pla                            ;remove counter from stack
1346 DD05
1347 DD05              ;-----------------------------------------------------------
1348 DD05              ;
1349 DD05              ;  Now check run queue
1350 DD05              ;
1351 DD05
1352 DD05 A0 0A 00              ldy   #o_TaskQueueHeader       ;initialize PtrToThisOne for runQ
1353 DD08 B7 01                 lda   [NDAListPtr],y
1354 DD0A 85 09                 sta   PtrToThisOne
1355 DD0C C8                    iny   
1356 DD0D C8                    iny   
1357 DD0E B7 01                 lda   [NDAListPtr],y
1358 DD10 85 0B                 sta   PtrToThisOne+2
1359 DD12
1360 DD12 A5 09        Loop1    lda   PtrToThisOne             ;check for nil address (end of list)
1361 DD14 D0 04                 bne   Loop2
1362 DD16 A5 0B                 lda   PtrToThisOne+2
1363 DD18 F0 52                 beq   AllDone
1364 DD1A              Loop2     
1365 DD1A A0 04 00              ldy   #o_RunPeriod             ; if period is $FFFF then it
1366 DD1D B7 09                 lda   [PtrToThisOne],y         ; does not want this shit
1367 DD1F C9 FF FF              cmp   #$FFFF
1368 DD22 F0 3A                 beq   SkipThisOne
1369 DD24
1370 DD24              ;------------------------------------------------------
1371 DD24              ;
1372 DD24              ; Calculate how many ticks since last service.
1373 DD24              ;
1374 DD24              ;    TickCount - LastServiced
1375 DD24              ;
1376 DD24              ; If result is negative, invert it (very unlikely since
1377 DD24              ; it takes two years of constant running for the tick
1378 DD24              ; count to wrap.
1379 DD24              ;
1380 DD24 A5 05                 lda   TickCount
1381 DD26 38                    sec   
1382 DD27 A0 08 00              ldy   #o_RunService
1383 DD2A F7 09                 sbc   [PtrToThisOne],y
1384 DD2C AA                    tax                            ; put result in x
1385 DD2D C8                    iny                            ; do rest of divide
1386 DD2E C8                    iny   
1387 DD2F A5 07                 lda   TickCount+2
1388 DD31 F7 09                 sbc   [PtrToThisOne],y
1389 DD33 10 06                 bpl   IsPos1                   ; if this is pos then it is 0
1390 DD35 8A                    txa                            ; if neg then we wrapped.
1391 DD36 49 FF FF              eor   #$FFFF
1392 DD39 1A                    inc   a
1393 DD3A AA                    tax   
1394 DD3B 8A           IsPos1   txa                            ; get back from x and see
1395 DD3C A0 04 00              ldy   #o_RunPeriod             ; if this is greater than
1396 DD3F D7 09                 cmp   [PtrToThisOne],y         ; period
1397 DD41 90 1B                 bcc   SkipThisOne
1398 DD43
1399 DD43              ;------------------------------------------------------
1400 DD43              ;
1401 DD43              ; It is greater than period so save new value for
1402 DD43              ; last serviced.
1403 DD43              ;
1404 DD43 A0 08 00              ldy   #o_RunService            ; fix last serviced field in rec
1405 DD46 A5 05                 lda   TickCount
1406 DD48 97 09                 sta   [PtrToThisOne],y
1407 DD4A C8                    iny   
1408 DD4B C8                    iny   
1409 DD4C A5 07                 lda   TickCount+2
1410 DD4E 97 09                 sta   [PtrToThisOne],y
1411 DD50              ;Check signature
1412 DD50 A0 06 00              ldy   #o_Signature
1413 DD53 B7 09                 lda   [PtrToThisOne],y
1414 DD55 C9 5A A5              cmp   #Signature
1415 DD58 D0 04                 bne   SkipthisOne              ;signature corrupt: skip it
1416 DD5A
1417 DD5A 22 0B E1 FE           jsl   ExecuteRunItem
1418 DD5E
1419 DD5E A7 09        SkipthisOne lda   [PtrToThisOne]        ; now bump pointer to current da
1420 DD60 AA                    tax   
1421 DD61 A0 02 00              ldy   #2
1422 DD64 B7 09                 lda   [PtrToThisOne],y
1423 DD66 85 0B                 sta   PtrToThisOne+2
1424 DD68 86 09                 stx   PtrToThisOne
1425 DD6A 80 A6                 bra   Loop1
1426 DD6C
1427 DD6C              AllDone   
1428 DD6C 20 B6 DF              jsr   UnlockNDAList
1429 DD6F 20 AE E0              jsr   EndNDACall
1430 DD72
1431 DD72 5C DF FB FE           jml   oEndCall0
1432 DD76
1433 DD76
1434 DD76                       ENDP 
1435 DD76
1436 DD76
1437 DD76
1438 DD76              ****************************************************************
1439 DD76              *
1440 DD76              * SystemClick
1441 DD76              *
1442 DD76              *              PtrToEvent
1443 DD76              *              PtrToWindow
1444 DD76              *              ResultFromFindWindow
1445 DD76              *              ====================
1446 DD76              *                                   <- SP
1447 DD76              *
1448 DD76              * This is called when an application determines that the mouse
1449 DD76              * went down in a system window.
1450 DD76              *
1451 DD76              * It is the job os SystemClick to
1452 DD76              *
1453 DD76              *      Drag if in DragRegion
1454 DD76              *      TrackGoAway and close if neccessary if in GoAwayBox
1455 DD76              *      TrackZoom and zoom if necessary if in ZoomBox
1456 DD76              *      Grow if in GrowBox
1457 DD76              *      Select if in content and not on top or Pass it on
1458 DD76              *         to the NDA
1459 DD76              *
1460 DD76              * Change History
1461 DD76              *
1462 DD76              * 02 Oct 87             Steven Glass
1463 DD76              *
1464 DD76              * No changes required to support new data structures.  However
1465 DD76              * a couple of changes were made to save code.
1466 DD76              *
1467 DD76              * 15 Mar 89         Steven Glass
1468 DD76              *
1469 DD76              * Added check for click in grow to select window if not front.
1470 DD76              *
1471 DD76              * Use FrontToAX instead of inline FrontWindow calls.
1472 DD76              *
1473 DD76              ****************************************************************
1474 DD76              SystemClick PROC EXPORT 
1475 DD76
1476 DD76                       DSect OrigDirect+2 
1477 DD76              ret1     block 3                        ; equates for zp after StartNDACall
1478 DD76              ret2     block 3 
1479 DD76              FindResult word 
1480 DD76              WindowPtr long 
1481 DD76              EventPtr long 
1482 DD76
1483 DD76 20 9A E0              jsr   StartNDACall
1484 DD79 20 A1 DF              jsr   DerefNDAList
1485 DD7C
1486 DD7C A5 21                 lda   FindResult               ; in content
1487 DD7E 29 FF 7F              and   #$7FFF                   ; mask off the system window bit
1488 DD81 38                    sec   
1489 DD82 E9 13 00              sbc   #19
1490 DD85 0A                    asl   a
1491 DD86 AA                    tax   
1492 DD87 FC 94 DD              jsr   (ClickTable,x)
1493 DD8A              @ignore   
1494 DD8A 20 B6 DF              jsr   UnlockNDAList
1495 DD8D 20 AE E0              jsr   EndNdaCall
1496 DD90
1497 DD90 5C 4F FC FE           jml   oEndCall10
1498 DD94
1499 DD94
1500 DD94 A6 DD        ClickTable DC W:ClickInContent          ; 19
1501 DD96 D6 DD                 DC W:ClickInDrag               ; 20
1502 DD98 21 DE                 DC W:ClickInGrow               ; 21
1503 DD9A 5A DE                 DC W:ClickInGoaway             ; 22
1504 DD9C 83 DE                 DC W:ClickInZoom               ; 23
1505 DD9E A6 DD                 DC W:ClickInInfo               ; 24
1506 DDA0 A6 DD                 DC W:ClickInVScroll            ; 25
1507 DDA2 A6 DD                 DC W:ClickInHScroll            ; 26
1508 DDA4 A6 DD                 DC W:ClickInFrame              ; 27
1509 DDA6              ClickTableEnd  
1510 DDA6
1511 DDA6              ****************************************************************
1512 DDA6              *
1513 DDA6              * A click in the content area means one of two things:
1514 DDA6              *
1515 DDA6              *      The da is the top window:   Pass click on to NDA
1516 DDA6              *      da is not the top window:   Select the sucker.
1517 DDA6              *
1518 DDA6              ****************************************************************
1519 DDA6              ClickInContent                          ; 
1520 DDA6              ClickInInfo                             ; 
1521 DDA6              ClickInVScroll                          ; 
1522 DDA6              ClickInHScroll                          ; 
1523 DDA6              ClickInFrame                            ; 
1524 DDA6
1525 DDA6                       import FrontToAX 
1526 DDA6
1527 DDA6              ;;;PassItAnyway
1528 DDA6 20 C3 E1              jsr   FrontToAX
1529 DDA9
1530 DDA9 C5 23                 cmp   WindowPtr
1531 DDAB D0 1B                 bne   SelectIt
1532 DDAD E4 25                 cpx   WindowPtr+2
1533 DDAF D0 17                 bne   SelectIt
1534 DDB1
1535 DDB1              ;------------------------------------------------------
1536 DDB1              ;
1537 DDB1              ; It is top so send the event on!
1538 DDB1              ;
1539 DDB1 20 CD DF              jsr   FindThisWindow
1540 DDB4 90 11                 bcc   ImConfused
1541 DDB6
1542 DDB6 20 22 E0              jsr   SetResID
1543 DDB9
1544 DDB9 A9 01 00              lda   #DAEventCode
1545 DDBC A6 27                 ldx   EventPtr
1546 DDBE A4 29                 ldy   EventPtr+2
1547 DDC0 22 91 E0 FE           jsl   SendAction
1548 DDC4
1549 DDC4 20 4D E0              jsr   RepResID
1550 DDC7
1551 DDC7 60           ImConfused rts   
1552 DDC8
1553 DDC8              SelectIt  
1554 DDC8 A5 25 48 A5           PushLong WindowPtr 
1555 DDCE A2 0E 11 22           _SelectWindow 
1556 DDD5 60                    rts   
1557 DDD6
1558 DDD6
1559 DDD6 A0 0E 00     ClickInDrag ldy   #o_modifiers          ; if this is shift click
1560 DDD9 B7 27                 lda   [EventPtr],y             ; then drag in current plain
1561 DDDB 29 00 01              and   #m_AppleKey              ; else bring to top then drag
1562 DDDE D0 0E                 bne   SkipSelect
1563 DDE0
1564 DDE0              ;------------------------------------------------------
1565 DDE0              ;
1566 DDE0              ; First see if we are the top window
1567 DDE0              ;
1568 DDE0 20 C3 E1              jsr   FrontToAX
1569 DDE3
1570 DDE3 C5 23                 cmp   WindowPtr
1571 DDE5 D0 04                 bne   MustSelect
1572 DDE7 E4 25                 cpx   WindowPtr+2
1573 DDE9 F0 03                 beq   SkipSelect
1574 DDEB
1575 DDEB 20 C8 DD     MustSelect jsr   SelectIt
1576 DDEE
1577 DDEE
1578 DDEE              SkipSelect  
1579 DDEE              ;
1580 DDEE              ; 3/16/89           Mensch
1581 DDEE              ; Added call to stilldown to be sure that the mouse button state hasn't
1582 DDEE              ; changed during the select.
1583 DDEE
1584 DDEE 48                    pha                            ; room for result
1585 DDEF F4 00 00              pea   00                       ; button number
1586 DDF2 A2 06 0E 22           _StillDown                     ; test for it to still be down
1587 DDF9 68                    pla   
1588 DDFA F0 24                 beq   @Done                    ; if not still down, then just leave...
1589 DDFC              ;
1590 DDFC              ; Done with change
1591 DDFC F4 00 00              PushWord #0                    ; default grid
1592 DDFF A0 0C 00              ldy   #o_Where+2               ; where
1593 DE02 B7 27                 lda   [EventPtr],y
1594 DE04 48                    pha   
1595 DE05 88                    dey   
1596 DE06 88                    dey   
1597 DE07 B7 27                 lda   [EventPtr],y
1598 DE09 48                    pha   
1599 DE0A F4 08 00              PushWord #8                    ; grace
1600 DE0D F4 00 00 F4           PushLong #0                    ; bounds rect (default)
1601 DE13 A5 25 48 A5           PushLong WindowPtr 
1602 DE19 A2 0E 1A 22           _DragWindow 
1603 DE20              @Done     
1604 DE20 60                    rts   
1605 DE21
1606 DE21              ClickInGrow  
1607 DE21 20 C3 E1              jsr   FrontToAX
1608 DE24 C5 23                 cmp   WindowPtr
1609 DE26 D0 A0                 bne   SelectIt
1610 DE28 E4 25                 cpx   WindowPtr+2
1611 DE2A D0 9C                 bne   SelectIt
1612 DE2C
1613 DE2C 48                    pha                            ; space for result
1614 DE2D 48                    pha   
1615 DE2E
1616 DE2E F4 14 00              PushWord #20                   ; min x
1617 DE31 F4 0A 00              PushWord #10                   ; min y
1618 DE34 A0 0C 00              ldy   #o_Where+2               ; where x
1619 DE37 B7 27                 lda   [EventPtr],y
1620 DE39 48                    pha   
1621 DE3A 88                    dey   
1622 DE3B 88                    dey   
1623 DE3C B7 27                 lda   [EventPtr],y             ; where y
1624 DE3E 48                    pha   
1625 DE3F A5 25 48 A5           PushLong WindowPtr             ; pointer to window
1626 DE45 A2 0E 1B 22           _GrowWindow 
1627 DE4C
1628 DE4C A5 25 48 A5           PushLong WindowPtr             ; don't forget to set the final size
1629 DE52 A2 0E 1C 22           _SizeWindow 
1630 DE59
1631 DE59 60                    rts   
1632 DE5A
1633 DE5A 48           ClickInGoAway pha                       ; space for result
1634 DE5B A0 0C 00              ldy   #o_Where+2               ; where x
1635 DE5E B7 27                 lda   [EventPtr],y
1636 DE60 48                    pha   
1637 DE61 88                    dey   
1638 DE62 88                    dey   
1639 DE63 B7 27                 lda   [EventPtr],y             ; where y
1640 DE65 48                    pha   
1641 DE66 A5 25 48 A5           PushLong WindowPtr             ; pointer to window
1642 DE6C A2 0E 18 22           _TrackGoaway 
1643 DE73
1644 DE73 68                    pla   
1645 DE74 F0 0C                 beq   DontClose
1646 DE76
1647 DE76
1648 DE76 A5 23                 lda   WindowPtr
1649 DE78 A6 25                 ldx   WindowPtr+2
1650 DE7A 20 CD DF              jsr   FindThisWindow
1651 DE7D 90 03                 bcc   DontClose
1652 DE7F
1653 DE7F 20 45 DC              jsr   DoCloseStuff
1654 DE82
1655 DE82 60           DontClose rts   
1656 DE83
1657 DE83
1658 DE83
1659 DE83 F4 00 00     ClickInZoom PushWord #0 
1660 DE86 A0 0C 00              ldy   #o_Where+2               ; where x
1661 DE89 B7 27                 lda   [EventPtr],y
1662 DE8B 48                    pha   
1663 DE8C 88                    dey   
1664 DE8D 88                    dey   
1665 DE8E B7 27                 lda   [EventPtr],y             ; where y
1666 DE90 48                    pha   
1667 DE91 A5 25 48 A5           PushLong WindowPtr             ; pointer to window
1668 DE97 A2 0E 26 22           _TrackZoom 
1669 DE9E
1670 DE9E 68                    pla   
1671 DE9F F0 0D                 beq   DontZoom
1672 DEA1
1673 DEA1 A5 25 48 A5           PushLong WindowPtr 
1674 DEA7 A2 0E 27 22           _ZoomWindow 
1675 DEAE
1676 DEAE 60           DontZoom rts   
1677 DEAF
1678 DEAF
1679 DEAF                       ENDP 
1680 DEAF
1681 DEAF
1682 DEAF
1683 DEAF
1684 DEAF              ****************************************************************
1685 DEAF              *
1686 DEAF              * SystemEdit
1687 DEAF              *
1688 DEAF              *        Space for boolean result
1689 DEAF              *        Edit Code
1690 DEAF              *        ------------------------
1691 DEAF              *                                   <-SP
1692 DEAF              *
1693 DEAF              * The application calls this when the user selects cut, copy
1694 DEAF              * paste, undo or clear from the edit menu.  The
1695 DEAF              * user passes the edit code on the stack.
1696 DEAF              *
1697 DEAF              * NDA returns boolean in a register.  True if action is
1698 DEAF              * taken, false otherwise.
1699 DEAF              *
1700 DEAF              * The Edit codes are
1701 DEAF              *
1702 DEAF              *                  Action code send     Code sent to System Edit
1703 DEAF              *                  to NDA               by application
1704 DEAF              *      Undo           5                        1
1705 DEAF              *      Cut            6                        2
1706 DEAF              *      Copy           7                        3
1707 DEAF              *      Paste          8                        4
1708 DEAF              *      Clear          9                        5
1709 DEAF              *
1710 DEAF              * Change History
1711 DEAF              *
1712 DEAF              * 02 Oct 87             Steven Glass
1713 DEAF              *
1714 DEAF              * No changes required to support new data structures.  However
1715 DEAF              * a couple of changes were made to save code.
1716 DEAF              *
1717 DEAF              * 19 Apr 89         Steven Glass
1718 DEAF              *
1719 DEAF              * Fixed bug where return code from DA was trashed while 
1720 DEAF              * restoring the resource manager's user id.
1721 DEAF              *
1722 DEAF              ****************************************************************
1723 DEAF              SystemEdit PROC EXPORT 
1724 DEAF
1725 DEAF
1726 DEAF                       import FrontToAX 
1727 DEAF
1728 DEAF
1729 DEAF                       DSect OrigDirect+2 
1730 DEAF              RTL1     block 3 
1731 DEAF              RTL2     block 3 
1732 DEAF              EditID   word 
1733 DEAF              Result   word 
1734 DEAF
1735 DEAF 20 9A E0              jsr   StartNDACall
1736 DEB2 20 A1 DF              jsr   DerefNDAList
1737 DEB5
1738 DEB5 64 23                 stz   Result                   ; start by assuming no!  added 19 Apr 89 SEG
1739 DEB7
1740 DEB7 20 C3 E1              jsr   FrontToAX
1741 DEBA
1742 DEBA 20 CD DF              jsr   FindThisWindow
1743 DEBD 90 12                 bcc   NotOurs
1744 DEBF
1745 DEBF 20 22 E0              jsr   SetResID
1746 DEC2
1747 DEC2 A5 21                 lda   EditID                   ; add the edit id number to
1748 DEC4 18                    clc                            ; undo code to get right code
1749 DEC5 69 04 00              adc   #DAUndoCode-1
1750 DEC8 22 91 E0 FE           jsl   SendAction               ; return result in a-reg
1751 DECC 85 23                 sta   Result                   ; Save it now!  added 19 Apr 89 SEG
1752 DECE 20 4D E0              jsr   RepResID
1753 DED1
1754 DED1              NotOurs   
1755 DED1 20 B6 DF              jsr   UnlockNDAList
1756 DED4 20 AE E0              jsr   EndNDACall
1757 DED7
1758 DED7 5C F7 FB FE           jml   oEndCall2
1759 DEDB
1760 DEDB                       ENDP 
1761 DEDB
1762 DEDB
1763 DEDB              ****************************************************************
1764 DEDB              *
1765 DEDB              * FixAppleMenu2
1766 DEDB              *
1767 DEDB              *      input     ID of menu to add to
1768 DEDB              *
1769 DEDB              *      output    none
1770 DEDB              *
1771 DEDB              * This is called fix apple menu but, it can fix any menu
1772 DEDB              * whose id is passed.
1773 DEDB              *
1774 DEDB              * Change History
1775 DEDB              *
1776 DEDB              * 02 Oct 87         Steven Glass
1777 DEDB              *
1778 DEDB              * Changes were needed here to use the new structure of the 
1779 DEDB              * NDAGlobals record.
1780 DEDB              *
1781 DEDB              * Additionally, I changed the code to use the stack to hold a counter
1782 DEDB              * instead of storage in line.
1783 DEDB              *
1784 DEDB              * 12 Oct 87         Steven Glass
1785 DEDB              *
1786 DEDB              * If an error occurs in parsing the menu data, we branch to
1787 DEDB              * die in where the process mode bits are cleared.
1788 DEDB              *
1789 DEDB              * 20-Nov-90         Dave Lyons
1790 DEDB              *
1791 DEDB              * Add sorting option.
1792 DEDB              *
1793 DEDB              ****************************************************************
1794 DEDB              FixAppleMenu2 PROC EXPORT 
1795 DEDB
1796 DEDB                       DSect OrigDirect+2
1797 DEDB              RTL1     block 3
1798 DEDB              RTL2     block 3
1799 DEDB              WhichMenu word 
1800 DEDB
1801 DEDB 20 9A E0              jsr   StartNDACall
1802 DEDE 20 A1 DF              jsr   DerefNDAList
1803 DEE1
1804 DEE1 A5 01                 lda   NDAListPtr
1805 DEE3 18                    clc   
1806 DEE4 69 0E 00              adc   #14
1807 DEE7 85 09                 sta   PtrToThisOne
1808 DEE9 A5 03                 lda   NDAListPtr+2
1809 DEEB 90 01                 bcc   @1
1810 DEED 1A                    inc   a
1811 DEEE 85 0B        @1       sta   PtrToThisOne+2
1812 DEF0 F4 00 00              PushWord #0                    ; init counter on stack
1813 DEF3
1814 DEF3 A3 01        InstallLoop lda   1,s
1815 DEF5 C7 01                 cmp   [NDAListPtr]
1816 DEF7 90 03                 bcc   Continue
1817 DEF9 82 70 00              brl   AllDone
1818 DEFC
1819 DEFC              Continue  
1820 DEFC A0 1E 00              ldy   #o_handle                ;this is the subroutine for ROM 03
1821 DEFF B7 09                 lda   [PtrToThisOne],y
1822 DF01 85 0D                 sta   NDAhandle
1823 DF03 C8                    iny   
1824 DF04 C8                    iny   
1825 DF05 B7 09                 lda   [PtrToThisOne],y
1826 DF07 85 0F                 sta   NDAHandle+2
1827 DF09 20 C1 DF              jsr   DerefNDAHandle
1828 DF0C A5 11                 lda   NDAPtr
1829 DF0E 18                    clc   
1830 DF0F 69 14 00              adc   #20
1831 DF12 85 11                 sta   NDAPtr
1832 DF14 90 02                 bcc   @NoCarryToLine
1833 DF16 E6 13                 inc   NDAPtr+2
1834 DF18
1835 DF18              @NoCarryToLine  
1836 DF18              ;
1837 DF18              ; Now I have to find the H (or h) that appears after
1838 DF18              ; the back slash.
1839 DF18              ;
1840 DF18 E2 20                 sep   #%00100000               ; switch to 8 bit a reg
1841 DF1A                       longa off
1842 DF1A
1843 DF1A A0 01 00              ldy   #1                       ; start with first char
1844 DF1D B7 11        @SlashLoop lda   [NDAPtr],y
1845 DF1F C9 5C                 cmp   #'\'
1846 DF21 F0 08                 beq   @FoundSlash
1847 DF23 C8                    iny   
1848 DF24 C0 FF 00              cpy   #255
1849 DF27 90 F4                 bcc   @SlashLoop
1850 DF29
1851 DF29 80 4C                 bra   DieHorribly              	; die horribly if the da is bad
1852 DF2B
1853 DF2B C8           @FoundSlash iny   
1854 DF2C B7 11        @HLoop   lda   [NDAPtr],y
1855 DF2E C9 48                 cmp   #'H'
1856 DF30 F0 0C                 beq   FoundH
1857 DF32 C9 68                 cmp   #'h'
1858 DF34 F0 08                 beq   FoundH
1859 DF36 C8                    iny   
1860 DF37 C0 FF 00              cpy   #255
1861 DF3A 90 F0                 bcc   @HLoop
1862 DF3C
1863 DF3C 80 39                 bra   DieHorribly              	; die horribly if the DA is bad
1864 DF3E
1865 DF3E C2 20        FoundH   rep   #%00100000
1866 DF40                       longa on
1867 DF40 C8                    iny                            ; put id number into string
1868 DF41 A3 01                 lda   1,s                      	; right after H
1869 DF43
1870 DF43 1A                    inc   a
1871 DF44 97 11                 sta   [NDAPtr],y
1872 DF46
1873 DF46 A5 13 48 A5           PushLong NDAPtr 
1874 DF4C F4 FF FF              PushWord #$FFFF 
1875 DF4F A5 21 48              PushWord WhichMenu 
1876 DF52 A2 0F 0F 22           _InsertMItem 
1877 DF59
1878 DF59 A5 09                 lda   PtrToThisOne
1879 DF5B 18                    clc   
1880 DF5C 69 24 00              adc   #NDARecSize
1881 DF5F 85 09                 sta   PtrToThisOne
1882 DF61 90 02                 bcc   @1
1883 DF63 E6 0B                 inc   PtrToThisOne+2
1884 DF65 A3 01        @1       lda   1,s
1885 DF67 1A                    inc   a
1886 DF68 83 01                 sta   1,s
1887 DF6A 80 87                 bra   InstallLoop
1888 DF6C
1889 DF6C 68           AllDone  pla                            ; clean up stack
1890 DF6D 20 B6 DF              jsr   UnlockNDAList
1891 DF70
1892 DF70 20 AE E0              jsr   ENDNDACall
1893 DF73 5C F7 FB FE           jml   oEndCall2
1894 DF77
1895 DF77                       export diehorribly
1896 DF77              DieHorribly  
1897 DF77 C2 30                 rep   #$30
1898 DF79 A9 12 05              lda   #BadNDA
1899 DF7C 29 FF 00              and   #$00FF
1900 DF7F 09 00 05              ora   #$0500
1901 DF82 48                    pha   
1902 DF83 F4 00 00 F4           PushLong #0 
1903 DF89 A2 03 15 22           _SysFailMgr 
1904 DF90
1905 DF90
1906 DF90              ****************************************************************
1907 DF90              *
1908 DF90              * GetNumNDAs
1909 DF90              *
1910 DF90              *     Input     none
1911 DF90              *     Output    number
1912 DF90              *
1913 DF90              *
1914 DF90              * Stack looks like:
1915 DF90              *
1916 DF90              *      Space For Output
1917 DF90              *      =================
1918 DF90              *                         <- SP
1919 DF90              *
1920 DF90              *
1921 DF90              * Change History
1922 DF90              *
1923 DF90              * 02 Oct 87             Steven Glass
1924 DF90              *
1925 DF90              * No changes were needed here to use the new structure of the 
1926 DF90              * NDAGlobals record.
1927 DF90              *
1928 DF90              * I changed the equates to use DSect macros.
1929 DF90              *
1930 DF90              * 23 Mar 88         Steven Glass
1931 DF90              *
1932 DF90              * There was a space in definition of DSect causing equs to be
1933 DF90              * wrong.
1934 DF90              *
1935 DF90              ****************************************************************
1936 DF90              GetNumNDAs PROC EXPORT 
1937 DF90
1938 DF90 20 9A E0              jsr   StartNDACall
1939 DF93 20 A1 DF              jsr   DerefNDAList
1940 DF96
1941 DF96 A7 01                 lda   [NDAListPtr]
1942 DF98 85 21                 sta   Result
1943 DF9A
1944 DF9A 20 AE E0              jsr   EndNDACall
1945 DF9D
1946 DF9D 5C DF FB FE           jml   oEndCall0
1947 DFA1
1948 DFA1                       ENDP 
1949 DFA1
1950 DFA1              ****************************************************************
1951 DFA1              *
1952 DFA1              * SystemMenu
1953 DFA1              *
1954 DFA1              * This is not really a call that anyone can use.
1955 DFA1              *
1956 DFA1              * Removed by Steven Glass
1957 DFA1              * 02 Oct 87
1958 DFA1              *
1959 DFA1              ****************************************************************
1960 DFA1
1961 DFA1
1962 DFA1
1963 DFA1                       title 'Desk Manager--desk/DESK.UTILS' 
1964 DFA1              ;               copy desk/desk.utils
1965 DFA1              ****************************************************************
1966 DFA1              *
1967 DFA1              * Desk Utility Routines
1968 DFA1              *
1969 DFA1              * Change History
1970 DFA1              *
1971 DFA1              * 02 Oct 87             Steven Glass
1972 DFA1              *
1973 DFA1              * Changes were made to get these to work with new global data
1974 DFA1              * structures.  The DerefNDAHandle routine no longer
1975 DFA1              * locks the handle (we assume that it is already locked)
1976 DFA1              *
1977 DFA1              * UnlockNDAHandle was removed (it was never called).
1978 DFA1              *
1979 DFA1              * A number of start/end's were combined into one.
1980 DFA1              *
1981 DFA1              *
1982 DFA1              ****************************************************************
1983 DFA1              DeskUtils PROC EXPORT 
1984 DFA1
1985 DFA1              ;----------------------------------------------------
1986 DFA1              ;
1987 DFA1              ; DerefNDAList
1988 DFA1              ;
1989 DFA1              ; Locks the NDAListHandle and deref's it into
1990 DFA1              ; NDAListPtr
1991 DFA1
1992 DFA1
1993 DFA1                       EXPORT DerefNDAList 
1994 DFA1              DerefNDAList  
1995 DFA1 A0 04 00              ldy   #4
1996 DFA4 B7 15                 lda   [NDAListHandle],y
1997 DFA6 09 00 80              ora   #$8000                   ;lock the handle
1998 DFA9 97 15                 sta   [NDAListHandle],y
1999 DFAB 88                    dey   
2000 DFAC 88                    dey   
2001 DFAD B7 15                 lda   [NDAListHandle],y
2002 DFAF 85 03                 sta   NDAListPtr+2
2003 DFB1 A7 15                 lda   [NDAListHandle]
2004 DFB3 85 01                 sta   NDAListPtr
2005 DFB5
2006 DFB5 60                    rts   
2007 DFB6
2008 DFB6              ;----------------------------------------------------
2009 DFB6              ;
2010 DFB6              ; UnlockNDAList
2011 DFB6              ;
2012 DFB6              ; Unlocks the NDAList handle.
2013 DFB6
2014 DFB6                       EXPORT UnlockNDAList 
2015 DFB6              UnlockNDAList  
2016 DFB6 A0 04 00              ldy   #4
2017 DFB9 B7 15                 lda   [NDAListHandle],y
2018 DFBB 29 FF 7F              and   #$7FFF
2019 DFBE 97 15                 sta   [NDAListHandle],y
2020 DFC0 60                    rts   
2021 DFC1
2022 DFC1              ;----------------------------------------------------
2023 DFC1              ;
2024 DFC1              ; DerefNDAHandle
2025 DFC1              ;
2026 DFC1              ; Derefs but does not bother locking the handle to
2027 DFC1              ; the NDA.
2028 DFC1              ;
2029 DFC1
2030 DFC1                       EXPORT DerefNDAHandle  
2031 DFC1 A0 02 00     DerefNDAHandle ldy   #2
2032 DFC4 B7 0D                 lda   [NDAHandle],y
2033 DFC6 85 13                 sta   NDAPtr+2
2034 DFC8 A7 0D                 lda   [NDAHandle]
2035 DFCA 85 11                 sta   NDAPtr
2036 DFCC 60                    rts   
2037 DFCD
2038 DFCD                       ENDP 
2039 DFCD
2040 DFCD
2041 DFCD              ****************************************************************
2042 DFCD              *
2043 DFCD              * FindThisWindow
2044 DFCD              *
2045 DFCD              * Inputs
2046 DFCD              *       a-reg:  low word of window ptr to look for
2047 DFCD              *       x-reg:  high word of window ptr to look for
2048 DFCD              *
2049 DFCD              * Outputs:
2050 DFCD              *   carry:  set if window is found
2051 DFCD              *           clear if window is not found
2052 DFCD              *   DPage:
2053 DFCD              *     OffsetToThisOne & PtrToThisOne set to point into
2054 DFCD              *     global data.
2055 DFCD              *
2056 DFCD              * We search through the NDAList for an NDA with a window ptr
2057 DFCD              * equal to the one passed in the a and x register.
2058 DFCD              *
2059 DFCD              * If we find it, we return with the carry set and the
2060 DFCD              * variables OffsetToThisOne and PtrToThisOne set on zero page.
2061 DFCD              *
2062 DFCD              * If we do not find it we return with carry clear.
2063 DFCD              *
2064 DFCD              * 
2065 DFCD              * Change History
2066 DFCD              *
2067 DFCD              * 02 Oct 87             Steven Glass
2068 DFCD              *
2069 DFCD              * Changes were made to get this to work with new global data
2070 DFCD              * structures.
2071 DFCD              *
2072 DFCD              ****************************************************************
2073 DFCD              FindThisWindow PROC EXPORT 
2074 DFCD
2075 DFCD DA                    phx                            ; store the pointer on the stack
2076 DFCE 48                    pha                            ;
2077 DFCF
2078 DFCF A0 0E 00              ldy   #SizeOfDeskGlobals       ; y points to first NDA record
2079 DFD2 A2 01 00              ldx   #1                       ; x is count
2080 DFD5
2081 DFD5 8A           KeepLooking txa                         ; compare count to num scrap records
2082 DFD6 C7 01                 cmp   [NDAListPtr]
2083 DFD8 F0 02                 beq   LastItem
2084 DFDA B0 37                 bcs   NotInTable
2085 DFDC
2086 DFDC 98           LastItem tya   
2087 DFDD 18                    clc   
2088 DFDE 69 1A 00              adc   #o_WindowPtr
2089 DFE1 A8                    tay   
2090 DFE2 B7 01                 lda   [NDAListPtr],y           ; get the type of this scrap record
2091 DFE4 C8                    iny                            ; bump y before compare
2092 DFE5 C8                    iny   
2093 DFE6 C3 01                 cmp   1,s                      ; compare to value on stack
2094 DFE8 D0 06                 bne   NotThisOne
2095 DFEA B7 01                 lda   [NDAListPtr],y
2096 DFEC C3 03                 cmp   3,s
2097 DFEE F0 09                 beq   FoundIt
2098 DFF0
2099 DFF0 98           NotThisOne tya                          ; bump y by size of record
2100 DFF1 18                    clc                            ; minus what we've already bumped
2101 DFF2 69 08 00              adc   #NDARecSize-o_WindowPtr-2
2102 DFF5 A8                    tay   
2103 DFF6 E8                    inx                            ; bump count by 1
2104 DFF7 80 DC                 bra   KeepLooking
2105 DFF9
2106 DFF9
2107 DFF9 68           FoundIt  pla                            ; clear pointer off stack
2108 DFFA 68                    pla   
2109 DFFB 98                    tya                            ; fix Offset To this one by subtracting
2110 DFFC 38                    sec                            ; off the extra we just added to get to
2111 DFFD E9 1C 00              sbc   #o_WindowPtr+2           ; window ptr.
2112 E000 85 05                 sta   OffsetToThisOne
2113 E002 64 07                 stz   OffsetToThisOne+2
2114 E004 A5 01                 lda   NDAListPtr
2115 E006 18                    clc   
2116 E007 65 05                 adc   OffsetToThisOne
2117 E009 85 09                 sta   PtrToThisOne
2118 E00B A5 03                 lda   NDAListPtr+2
2119 E00D 65 07                 adc   OffsetToThisOne+2
2120 E00F 85 0B                 sta   PtrToThisOne+2
2121 E011 38                    sec   
2122 E012 60                    rts   
2123 E013
2124 E013              NotInTable  
2125 E013 68                    pla   
2126 E014 68                    pla   
2127 E015 18           @notfound clc   
2128 E016 60                    rts   
2129 E017
2130 E017                       ENDP 
2131 E017
2132 E017              ****************************************************************
2133 E017              *
2134 E017              * AreWeTop
2135 E017              *
2136 E017              * Decides if the top window is a system window.  If it is
2137 E017              * then AreWeTop returns with carry set.  If the top window
2138 E017              * is not a system window, then AreWeTop returns with carry
2139 E017              * clear.
2140 E017              *
2141 E017              * Additionally, if the window is a system window, I call
2142 E017              * find this window which sets up PtrToThisOne.  FindThisWindow
2143 E017              * must also succeed for AreWeTop to return true.
2144 E017              *
2145 E017              *
2146 E017              * Change History
2147 E017              *
2148 E017              * 02 Oct 87             Steven Glass
2149 E017              *
2150 E017              * No changes were needed for new data structures but
2151 E017              * I changed a PushLong #0 to pha pha to save space.
2152 E017              *
2153 E017              * 15 mar 89         Steven Glass
2154 E017              *
2155 E017              * Uses FrontToAX instead of calling FrontWindow directly
2156 E017              * saving lots of code.
2157 E017              *
2158 E017              * Also branch directly to FindThisWindow rather than
2159 E017              * jsr followed by rts.  This saves more code.
2160 E017              *
2161 E017              ****************************************************************
2162 E017              AreWeTop PROC EXPORT 
2163 E017
2164 E017
2165 E017 20 C3 E1              jsr   FrontToAX
2166 E01A A8                    tay   
2167 E01B D0 B0                 bne   FindthisWindow0
2168 E01D 9B                    txy   
2169 E01E D0 AD                 bne   FindThisWindow0
2170 E020
2171 E020 18           NotSystem clc   
2172 E021 60                    rts   
2173 E022
2174 E022                       ENDP 
2175 E022
2176 E022
2177 E022              ****************************************************************
2178 E022              *
2179 E022              FutzResIDs proc 
2180 E022              *
2181 E022              * Two routines here are used to set and restore the Resource
2182 E022              * Manager's current Resource App.
2183 E022              *
2184 E022              * These calls are meant to be made around calls to the
2185 E022              * NDA.  Example:
2186 E022              *
2187 E022              *                   jsr SetResID
2188 E022              *                   send msg to NDA
2189 E022              *                   jsr RepResID
2190 E022              *
2191 E022              * The first call puts the current resID on the stack,
2192 E022              * The second call pulls it off.
2193 E022              *
2194 E022              *
2195 E022              * Inputs:
2196 E022              *                   none
2197 E022              *
2198 E022              * Outputs:
2199 E022              *                   none
2200 E022              *
2201 E022              * External Refs:
2202 E022              *                   none
2203 E022              *
2204 E022              * Entry Points:
2205 E022                       Export SetResID 
2206 E022                       Export RepResID 
2207 E022              *
2208 E022                       longa on                       ; mode
2209 E022                       longi on
2210 E022              *
2211 E022              * Change History
2212 E022              *
2213 E022              * 01 Mar 89         Steven Glass & Harry Yee
2214 E022              *
2215 E022              * Harry scolds steve and tells him that you cannot call the 
2216 E022              * resource manager and expect it to work, if the resource 
2217 E022              * manager is not there.
2218 E022              *
2219 E022              * No disk other that 4.1 worked at all.
2220 E022              *
2221 E022              ****************************************************************
2222 E022
2223 E022 FA           SetResID plx                            ; make room on the stack above
2224 E023 48                    pha                            ; the rts
2225 E024 DA                    phx   
2226 E025
2227 E025 F4 00 00              pea   0                        ; call resource status
2228 E028 A2 1E 06 22           _ResourceStatus 
2229 E02F 68                    pla                            ; get result in a-reg
2230 E030 B0 1A                 bcs   @Done                    ; carry set means got dispatch error
2231 E032 F0 18                 beq   @Done                    ; 0 means resource manager not active
2232 E034
2233 E034 48                    pha                            ; get the current res app id
2234 E035 A2 1E 14 22           _GetCurResourceApp 
2235 E03C 68                    pla   
2236 E03D 83 03                 sta   3,s                      ; put it on the stack above the RTS
2237 E03F
2238 E03F A0 22 00              ldy   #o_UserID                ; set the id of the NDA about to be called
2239 E042 B7 09                 lda   [PtrToThisOne],y
2240 E044 48                    pha   
2241 E045 A2 1E 13 22           _SetCurResourceApp 
2242 E04C
2243 E04C 60           @Done    rts                            ; done
2244 E04D
2245 E04D
2246 E04D
2247 E04D
2248 E04D FA           RepResID plx                            ; pull off the old ID and put back
2249 E04E 68                    pla   
2250 E04F DA                    phx                            ; the rts addr
2251 E050 48                    pha                            ; save id on this side of rts adr
2252 E051
2253 E051 F4 00 00              pea   0                        ; call status
2254 E054 A2 1E 06 22           _ResourceStatus 
2255 E05B 68                    pla                            ; get status result
2256 E05C FA                    plx                            ; get id off stack
2257 E05D A8                    tay                            ; set the zero bit of processor
2258 E05E B0 0A                 bcs   @Done
2259 E060 F0 08                 beq   @Done
2260 E062
2261 E062
2262 E062
2263 E062 DA                    phx                            ; push id now in x-reg
2264 E063 A2 1E 13 22           _SetCurResourceApp 
2265 E06A
2266 E06A 60           @Done    rts                            ; done.
2267 E06B
2268 E06B                       ENDP 
2269 E06B
2270 E06B
2271 E06B              ****************************************************************
2272 E06B              *
2273 E06B              SendOpen PROC EXPORT 
2274 E06B              *
2275 E06B              * This routine transfers control to the open routine of the
2276 E06B              * DA pointed to by PointerToThisOne.  All registers and
2277 E06B              * relative stack locations are preserved.  Control returns
2278 E06B              * from the DA to the Calling routine, not here.
2279 E06B              *
2280 E06B              *
2281 E06B              *
2282 E06B              * Inputs:
2283 E06B              *                   a, x and y are all passed on to the NDA
2284 E06B              *                   unchanged.
2285 E06B              *
2286 E06B              * Outputs:
2287 E06B              *                   none
2288 E06B              *
2289 E06B              * External Refs:
2290 E06B              *                   none
2291 E06B              *
2292 E06B              * Entry Points:
2293 E06B                       ENTRY SendSomething 
2294 E06B              *
2295 E06B                       longa on                       ; mode
2296 E06B                       longi on
2297 E06B              *
2298 E06B              * Change History
2299 E06B              *
2300 E06B              * 02 Oct 87             Steven Glass
2301 E06B              *
2302 E06B              * No chnages were necessary to support the new data structures.
2303 E06B              *
2304 E06B              * 19 Feb 89         Steven Glass
2305 E06B              *
2306 E06B              * All the send routines ended the same way, so they now 
2307 E06B              * share code with SendOpen.  The new entry point is SendSomething.
2308 E06B              *
2309 E06B              ****************************************************************
2310 E06B
2311 E06B
2312 E06B              s_YReg   equ   1
2313 E06B              s_AReg   equ   3
2314 E06B              s_AdrForOpen equ   5
2315 E06B
2316 E06B 48                    pha                            ; put 3 bytes on stack
2317 E06C 8B                    phb                            ; for addr of action routine
2318 E06D
2319 E06D 48                    pha                            ; save a
2320 E06E 5A                    phy                            ; save y
2321 E06F
2322 E06F A0 03 00              ldy   #o_Open+1                ; get addr from table
2323 E072
2324 E072              SendSomething  
2325 E072 B7 09                 lda   [PtrToThisOne],y
2326 E074 83 06                 sta   s_AdrForOpen+1,s
2327 E076 88                    dey   
2328 E077 B7 09                 lda   [PtrToThisOne],y         ; rtl adds 1 so sub 1
2329 E079 3A                    dec   a
2330 E07A 83 05                 sta   s_AdrForOpen,s
2331 E07C
2332 E07C 7A                    ply   
2333 E07D 68                    pla   
2334 E07E
2335 E07E 6B                    rtl   
2336 E07F
2337 E07F                       ENDP 
2338 E07F
2339 E07F
2340 E07F              ****************************************************************
2341 E07F              *
2342 E07F              * SendClose
2343 E07F              *
2344 E07F              * This routine transfers control to the close routine of the
2345 E07F              * DA pointed to by PointerToThisOne.  All registers and
2346 E07F              * relative stack locations are preserved.  Control returns
2347 E07F              * from the DA to the Calling routine, not here.
2348 E07F              *
2349 E07F              *
2350 E07F              *
2351 E07F              * Change History
2352 E07F              *
2353 E07F              * 02 Oct 87             Steven Glass
2354 E07F              *
2355 E07F              * No chnages were necessary to support the new data structures.
2356 E07F              *
2357 E07F              ****************************************************************
2358 E07F              SendClose PROC EXPORT 
2359 E07F
2360 E07F              s_YReg   equ   1
2361 E07F              s_AReg   equ   3
2362 E07F              s_AdrForClose equ   5
2363 E07F
2364 E07F 48                    pha                            ; put 3 bytes on stack
2365 E080 8B                    phb                            ; for addr of action routine
2366 E081
2367 E081 48                    pha                            ; save a
2368 E082 5A                    phy                            ; save y
2369 E083
2370 E083 A0 07 00              ldy   #o_Close+1               ; get addr from table
2371 E086 80 EA                 bra   SendSomething
2372 E088
2373 E088                       ENDP 
2374 E088
2375 E088
2376 E088              ****************************************************************
2377 E088              *
2378 E088              * SendInit
2379 E088              *
2380 E088              * This routine transfers control to the init routine of the
2381 E088              * DA pointed to by PointerToThisOne.  All registers and
2382 E088              * relative stack locations are preserved.  Control returns
2383 E088              * from the DA to the Calling routine, not here.
2384 E088              *
2385 E088              *
2386 E088              *
2387 E088              * Change History
2388 E088              *
2389 E088              * 02 Oct 87             Steven Glass
2390 E088              *
2391 E088              * No chnages were necessary to support the new data structures.
2392 E088              *
2393 E088              ****************************************************************
2394 E088              SendInit PROC EXPORT 
2395 E088
2396 E088              s_YReg   equ   1
2397 E088              s_AReg   equ   3
2398 E088              s_AdrForInit equ   5
2399 E088
2400 E088 48                    pha                            ; put 3 bytes on stack
2401 E089 8B                    phb                            ; for addr of action routine
2402 E08A
2403 E08A 48                    pha                            ; save a
2404 E08B 5A                    phy                            ; save y
2405 E08C
2406 E08C A0 0F 00              ldy   #o_Init+1                ; get addr from table
2407 E08F 80 E1                 bra   SendSomething
2408 E091
2409 E091                       ENDP 
2410 E091
2411 E091
2412 E091              ****************************************************************
2413 E091              *
2414 E091              * SendAction
2415 E091              *
2416 E091              * Inputs
2417 E091              *    All-registers
2418 E091              *    PtrToThisOne
2419 E091              *
2420 E091              * Output
2421 E091              *    Depends on routine called.
2422 E091              *
2423 E091              * This routine transfers control to the action routine of the
2424 E091              * DA pointed to by PointerToThisOne.  All registers and
2425 E091              * relative stack locations are preserved.  Control returns
2426 E091              * from the DA to the Calling routine, not here.
2427 E091              *
2428 E091              *
2429 E091              * Change History
2430 E091              *
2431 E091              * 02 Oct 87             Steven Glass
2432 E091              *
2433 E091              * No chnages were necessary to support the new data structures.
2434 E091              *
2435 E091              ****************************************************************
2436 E091              SendAction PROC EXPORT 
2437 E091
2438 E091              s_YReg   equ   1
2439 E091              s_AReg   equ   3
2440 E091              s_AdrForAction equ   5
2441 E091
2442 E091 48                    pha                            ; put 3 bytes on stack
2443 E092 8B                    phb                            ; for addr of action routine
2444 E093
2445 E093 48                    pha                            ; save a
2446 E094 5A                    phy                            ; save y
2447 E095
2448 E095 A0 0B 00              ldy   #o_Action+1              ; get addr from table
2449 E098 80 D8                 bra   SendSomething
2450 E09A
2451 E09A                       ENDP 
2452 E09A
2453 E09A
2454 E09A              ****************************************************************
2455 E09A              *
2456 E09A              * StartNDACall
2457 E09A              *
2458 E09A              * Inputs:
2459 E09A              *    A-reg:  Low word of WAP value
2460 E09A              *    Y-reg:  High word of WAP value
2461 E09A              *
2462 E09A              * Outputs
2463 E09A              *    D-reg:  set to place on stack
2464 E09A              *    b-reg:  set to code bank (k)
2465 E09A              *    a-reg, x-reg and y-reg are trashed.
2466 E09A              *
2467 E09A              * Side Effects:
2468 E09A              *
2469 E09A              *    busy flag is incremented.
2470 E09A              *
2471 E09A              *
2472 E09A              * This routine sets up direct page, adjusts the stack and
2473 E09A              * data bank, calls IncBusyFlag in preperation for the
2474 E09A              * start of a NDA Calls.
2475 E09A              *
2476 E09A              * It also leaves the WAP value (the handle to the global
2477 E09A              * data structure) in the NDAListHandle field on direct page.
2478 E09A              *
2479 E09A              *
2480 E09A              *
2481 E09A              * Change History
2482 E09A              *
2483 E09A              * 02 Oct 87             Steven Glass
2484 E09A              *
2485 E09A              * Changes were necessary to support the new data structures.  The
2486 E09A              * A & Y registers contain the WAP value for this tool.
2487 E09A              *
2488 E09A              ****************************************************************
2489 E09A              StartNDACall PROC EXPORT 
2490 E09A
2491 E09A FA                    plx                            ; get rts adr in x
2492 E09B
2493 E09B 0B                    phd                            ; save direct reg
2494 E09C
2495 E09C 5A                    phy                            ; this is the handle to the
2496 E09D 48                    pha                            ; global data structure.
2497 E09E
2498 E09E 3B                    tsc                            ; and get my zero page off stack
2499 E09F 38                    sec   
2500 E0A0 E9 14 00              sbc   #StdZPSize-4
2501 E0A3 1B                    tcs   
2502 E0A4 5B                    tcd   
2503 E0A5
2504 E0A5 8B                    phb                            ; save data bank
2505 E0A6 4B                    phk                            ; set data bank to
2506 E0A7 AB                    plb                            ; code bank
2507 E0A8
2508 E0A8
2509 E0A8 22 64 00 E1           jsl   IncBusyFlg
2510 E0AC
2511 E0AC DA                    phx                            ; put rts adr back on stack
2512 E0AD 60                    rts   
2513 E0AE
2514 E0AE                       ENDP 
2515 E0AE
2516 E0AE
2517 E0AE
2518 E0AE
2519 E0AE              ****************************************************************
2520 E0AE              *
2521 E0AE              * EndNDACall
2522 E0AE              *
2523 E0AE              * Inputs:
2524 E0AE              *     None
2525 E0AE              *
2526 E0AE              * Outputs:
2527 E0AE              *     None, but the x-register is preserved!
2528 E0AE              *
2529 E0AE              * This routine restores direct page and data bank, and adjusts
2530 E0AE              * the stack and calls DecBusyFlg to undo everything that 
2531 E0AE              * StartNDACall did.
2532 E0AE              *
2533 E0AE              *
2534 E0AE              *
2535 E0AE              * Change History
2536 E0AE              *
2537 E0AE              * 02 Oct 87             Steven Glass
2538 E0AE              *
2539 E0AE              * Changes were made to support the new data structures.  This 
2540 E0AE              * routine now undoes everything done by the StartNDACall including
2541 E0AE              * the busyflag and the direct page.
2542 E0AE              *
2543 E0AE              ****************************************************************
2544 E0AE              EndNDACall PROC EXPORT 
2545 E0AE
2546 E0AE 7A                    ply                            ; save rts adr in y
2547 E0AF
2548 E0AF AB                    plb                            ; restore data bank
2549 E0B0 3B                    tsc                            ; adjust stack
2550 E0B1 18                    clc   
2551 E0B2 69 18 00              adc   #StdZPSize
2552 E0B5 1B                    tcs   
2553 E0B6
2554 E0B6 2B                    pld                            ; restore direct page
2555 E0B7
2556 E0B7
2557 E0B7 5A                    phy                            ; put rts back on stack
2558 E0B8
2559 E0B8 22 68 00 E1           jsl   DecBusyFlg
2560 E0BC
2561 E0BC 60                    rts   
2562 E0BD
2563 E0BD                       ENDP 
2564 E0BD
2565 E0BD
2566 E0BD              **********************************************************************
2567 E0BD              *
2568 E0BD              * AddToRunQ
2569 E0BD              *
2570 E0BD              *  Written by Konstantin Othmer  Sept 29 88
2571 E0BD              *
2572 E0BD              * Adds a task to the run queue.  
2573 E0BD              *  Input:
2574 E0BD              *    HeaderPtr      LONG                ;address of routine to add
2575 E0BD              *
2576 E0BD              *  Output:
2577 E0BD              *    None
2578 E0BD              *
2579 E0BD              **********************************************************************
2580 E0BD              AddToRunQ PROC EXPORT 
2581 E0BD
2582 E0BD              PtrToHeader equ   FirstInput
2583 E0BD
2584 E0BD 20 9A E0              jsr   StartNDACall
2585 E0C0 20 A1 DF              jsr   DerefNDAList             ;set up NDAListPtr
2586 E0C3
2587 E0C3 D4 23                 pei   PtrToHeader+2
2588 E0C5 D4 21                 pei   PtrToHeader
2589 E0C7
2590 E0C7 A5 01                 lda   NDAListPtr
2591 E0C9 18                    clc   
2592 E0CA 69 0A 00              adc   #o_TaskQueueHeader
2593 E0CD AA                    tax   
2594 E0CE A5 03                 lda   NDAListPtr+2
2595 E0D0 69 00 00              adc   #0
2596 E0D3 48                    pha   
2597 E0D4 DA                    phx   
2598 E0D5
2599 E0D5              ;	_AddToQueue	;this needs to be made into a macro
2600 E0D5 A2 03 2E              ldx   #AddToQueue
2601 E0D8 22 00 00 E1           jsl   Dispatch1
2602 E0DC
2603 E0DC AA                    tax   
2604 E0DD 20 AE E0              jsr   EndNDACall
2605 E0E0
2606 E0E0 5C 12 FC FE           jml   oErrOut4
2607 E0E4
2608 E0E4                       ENDP 
2609 E0E4
2610 E0E4
2611 E0E4              **********************************************************************
2612 E0E4              *
2613 E0E4              * RemoveFromRunQ
2614 E0E4              *
2615 E0E4              *  Written by Konstantin Othmer  Sept 29 88
2616 E0E4              *
2617 E0E4              * Removes a task from the run queue.  
2618 E0E4              *  Input:
2619 E0E4              *    HeaderPtr      LONG                ;address of routine to add
2620 E0E4              *
2621 E0E4              *  Output:
2622 E0E4              *    None
2623 E0E4              *
2624 E0E4              **********************************************************************
2625 E0E4              RemoveFromRunQ PROC EXPORT 
2626 E0E4
2627 E0E4              PtrToHeader equ   FirstInput
2628 E0E4
2629 E0E4 20 9A E0              jsr   StartNDACall
2630 E0E7 20 A1 DF              jsr   DerefNDAList             ;set up NDAListPtr
2631 E0EA
2632 E0EA D4 23                 pei   PtrToHeader+2
2633 E0EC D4 21                 pei   PtrToHeader
2634 E0EE
2635 E0EE A5 01                 lda   NDAListPtr
2636 E0F0 18                    clc   
2637 E0F1 69 0A 00              adc   #o_TaskQueueHeader
2638 E0F4 AA                    tax   
2639 E0F5 A5 03                 lda   NDAListPtr+2
2640 E0F7 69 00 00              adc   #0
2641 E0FA 48                    pha   
2642 E0FB DA                    phx   
2643 E0FC
2644 E0FC              ;	_DeleteFromQueue	;this needs to be made into a macro
2645 E0FC A2 03 2F              ldx   #DeleteFromQueue
2646 E0FF 22 00 00 E1           jsl   Dispatch1
2647 E103
2648 E103 AA                    tax   
2649 E104 20 AE E0              jsr   EndNDACall
2650 E107
2651 E107 5C 12 FC FE           jml   oErrOut4
2652 E10B
2653 E10B                       ENDP 
2654 E10B
2655 E10B
2656 E10B              ****************************************************************
2657 E10B              *
2658 E10B              * ExecuteRunItem
2659 E10B              *
2660 E10B              * Inputs
2661 E10B              *    PointerToThisOne
2662 E10B              *
2663 E10B              * Output
2664 E10B              *    Depends on RunQ item
2665 E10B              *
2666 E10B              * This routine transfers control to PointerToThisOne + RunEntry.
2667 E10B              * All registers and relative stack locations are preserved.
2668 E10B              * Control returns from the run item to the Calling routine, not here.
2669 E10B              *
2670 E10B              *
2671 E10B              * Added by:
2672 E10B              *
2673 E10B              * Konstantin Othmer                     02 Oct 88
2674 E10B              *
2675 E10B              ****************************************************************
2676 E10B              ExecuteRunItem PROC EXPORT 
2677 E10B
2678 E10B              s_YReg   equ   1
2679 E10B              s_AReg   equ   3
2680 E10B              s_AdrForAction equ   5                  ;stack + 5 has low byte
2681 E10B
2682 E10B 48                    pha                            ; put 3 bytes on stack
2683 E10C 8B                    phb                            ; for addr of action routine
2684 E10D
2685 E10D 48                    pha                            ; save a
2686 E10E 5A                    phy                            ; save y
2687 E10F
2688 E10F A5 0A                 lda   PtrToThisOne+1           ;high byte and PCBank
2689 E111 83 06                 sta   s_AdrForAction+1,s       ;high byte and PCBank
2690 E113
2691 E113 A9 0C 00              lda   #o_RunEntry              ; Code starts here
2692 E116 18                    clc   
2693 E117 65 09                 adc   PtrToThisOne
2694 E119 3A                    dec   a
2695 E11A 83 05                 sta   s_AdrForAction,s         ;low and high byte return address
2696 E11C
2697 E11C 7A                    ply   
2698 E11D 68                    pla   
2699 E11E
2700 E11E 6B                    rtl                            ;jump to RunEntry
2701 E11F
2702 E11F                       ENDP 
2703 E11F
2704 E11F
2705 E11F              ****************************************************************
2706 E11F              *
2707 E11F              * RemoveNDA
2708 E11F              *
2709 E11F              *           HandleToNDA
2710 E11F              *
2711 E11F              * This is the routine we use to remove a new da in the system.
2712 E11F              *
2713 E11F              * This call removes an entry in the NDAList.  This
2714 E11F              * entry contains most of the information in the NDA header.
2715 E11F              *
2716 E11F              * Change History
2717 E11F              *
2718 E11F              * 05 Oct 88             Added by Konstantin Othmer
2719 E11F              *
2720 E11F              ****************************************************************
2721 E11F              RemoveNDA PROC EXPORT 
2722 E11F
2723 E11F                       import DerefNDAList 
2724 E11F                       import UnlockNDAList 
2725 E11F
2726 E11F                       DSect OrigDirect+2 
2727 E11F              Rtl1     block 3 
2728 E11F              RTL2     block 3 
2729 E11F              UserHandle long 
2730 E11F
2731 E11F 20 9A E0              jsr   StartNDACall
2732 E122 20 A1 DF              jsr   DerefNDAList             ;this locks the handle
2733 E125
2734 E125              ;First set up PtrToThisOne to first NDA in the list
2735 E125
2736 E125 A9 0E 00              lda   #SizeofDeskGlobals
2737 E128 18                    clc   
2738 E129 65 01                 adc   NDAListPtr
2739 E12B 85 09                 sta   PtrToThisOne
2740 E12D A5 03                 lda   NDAListPtr+2
2741 E12F 69 00 00              adc   #0
2742 E132 85 0B                 sta   PtrToThisOne+2
2743 E134
2744 E134 A7 01                 lda   [NDAListPtr]             ;number of entries
2745 E136 48                    pha   
2746 E137
2747 E137              ;Scan list to try to find UserHandle in the o_Handle field of the NDAList.
2748 E137
2749 E137 68           SearchLoop pla   
2750 E138 F0 49                 beq   NotFound
2751 E13A 3A                    dec   a                        ;keep track of number left to search
2752 E13B 48                    pha   
2753 E13C
2754 E13C A0 1E 00              ldy   #o_Handle
2755 E13F A5 21                 lda   UserHandle
2756 E141 D7 09                 cmp   [PtrToThisOne],y
2757 E143 D0 0A                 bne   Search1
2758 E145 C8                    iny   
2759 E146 C8                    iny   
2760 E147 A5 23                 lda   UserHandle+2
2761 E149 D7 09                 cmp   [PtrToThisOne],y
2762 E14B D0 02                 bne   Search1
2763 E14D 80 11                 bra   FoundIt
2764 E14F
2765 E14F              ;
2766 E14F              ; Didn't find it yet.  Set up PtrtoThisOne for next NDA record and search again
2767 E14F              ;
2768 E14F A5 09        Search1  lda   PtrToThisOne
2769 E151 18                    clc   
2770 E152 69 24 00              adc   #NDARecSize
2771 E155 85 09                 sta   PtrToThisOne
2772 E157 A5 0B                 lda   PtrToThisOne+2
2773 E159 69 00 00              adc   #0
2774 E15C 85 0B                 sta   PtrToThisOne+2
2775 E15E 80 D7                 bra   SearchLoop
2776 E160
2777 E160              ;
2778 E160              ;found it.  Now we need to remove it.  All the remaining NDA's move up 20 bytes
2779 E160              ; Top word on stack contains the number of NDAs left in list (not including this one)
2780 E160              ;
2781 E160 A7 01        FoundIt  lda   [NDAListPtr]             ;number of NDAs:  decrement because
2782 E162 3A                    dec   a                        ;we remove one
2783 E163 87 01                 sta   [NDAListPtr]
2784 E165
2785 E165              MoveStart  
2786 E165 68           enter    pla                            ;number of NDA's left to search/move
2787 E166 F0 20                 beq   SizeHandle               ;is this the last one?
2788 E168 3A                    dec   a
2789 E169 48                    pha                            ;This now is the number of NDA's we need to
2790 E16A                                                      ;move
2791 E16A              ;
2792 E16A              ;move record at PtrToThisOne+NDARecSize to PtrToThisOne
2793 E16A              ;
2794 E16A A2 22 00              ldx   #NDARecSize-2            ;length of record to move
2795 E16D A0 46 00              ldy   #NDARecSize*2-2          ;end of source
2796 E170
2797 E170 B7 09        MoveIt   lda   [PtrToThisOne],y
2798 E172 5A                    phy   
2799 E173 DA                    phx   
2800 E174 7A                    ply                            ;transfer destination offset to y
2801 E175 97 09                 sta   [PtrToThisOne],y
2802 E177 7A                    ply                            ;get y back
2803 E178 88                    dey   
2804 E179 88                    dey   
2805 E17A CA                    dex   
2806 E17B CA                    dex                            ;update offsets
2807 E17C E0 FE FF              cpx   #-2
2808 E17F D0 EF                 bne   MoveIt
2809 E181 80 E2                 bra   MoveStart
2810 E183              ;
2811 E183              ; this is inserted here so we can use a short branch to get to it
2812 E183 A2 10 05     NotFound ldx   #daNotFound              ;Not found Error
2813 E186 80 31                 bra   GetOut
2814 E188              ; end of insert
2815 E188
2816 E188              ;
2817 E188              ; We've removed it.  Now free up extra room w/ memory manager
2818 E188              ;
2819 E188 48           SizeHandle pha                          ; space for result
2820 E189 48                    pha   
2821 E18A A7 01                 lda   [NDAListPtr]             ;new number of NDAs
2822 E18C 48                    pha                            ; New Number of entries 
2823 E18D F4 24 00              PushWord #NDARecSize           ; Size of a NDArecord
2824 E190 A2 0B 09 22           _Multiply 
2825 E197
2826 E197 A3 01                 lda   1,s                      ; This is size of all NDA Records
2827 E199 18                    clc                            ;now add in the header size (Deskglobals)
2828 E19A 69 0E 00              adc   #SizeOfDeskGlobals
2829 E19D
2830 E19D 83 01        SizeIsAdjusted sta   1,s
2831 E19F A3 03                 lda   3,s
2832 E1A1 69 00 00              adc   #0
2833 E1A4 83 03                 sta   3,s                      ;top of stack contains new handle size
2834 E1A6
2835 E1A6 20 B6 DF              jsr   UnlockNDAList
2836 E1A9
2837 E1A9 D4 17                 pei   NDAListHandle+2
2838 E1AB D4 15                 pei   NDAListHandle
2839 E1AD A2 02 19 22           _SetHandleSize 
2840 E1B4 B0 0A                 bcs   ERROR
2841 E1B6
2842 E1B6 A2 00 00     AllDone  ldx   #0                       ;Successful removal
2843 E1B9
2844 E1B9 20 AE E0     GetOut   jsr   EndNDACall
2845 E1BC 5C 12 FC FE           jml   oErrOut4
2846 E1C0
2847 E1C0 AA           Error    tax                            ;Handle Error
2848 E1C1 80 F6                 bra   GetOut
2849 E1C3
2850 E1C3                       ENDP 
2851 E1C3
2852 E1C3
2853 E1C3              ****************************************************************
2854 E1C3              *
2855 E1C3              FrontToAX PROC export 
2856 E1C3              *
2857 E1C3              * Returns the pointer to the front window to in the A & X 
2858 E1C3              * registers.
2859 E1C3              *
2860 E1C3              *
2861 E1C3              * Inputs:
2862 E1C3              *	none
2863 E1C3              *
2864 E1C3              * Outputs:
2865 E1C3              *	a-reg
2866 E1C3              *	x-reg
2867 E1C3              *
2868 E1C3              * External Refs:
2869 E1C3              *	none
2870 E1C3              *
2871 E1C3              * Entry Points:
2872 E1C3              *	none
2873 E1C3              *
2874 E1C3                       longa on                       ; mode
2875 E1C3                       longi on
2876 E1C3              *
2877 E1C3              ****************************************************************
2878 E1C3 48                    pha   
2879 E1C4 48                    pha   
2880 E1C5 A2 0E 15 22           _FrontWindow 
2881 E1CC 68                    pla   
2882 E1CD FA                    plx   
2883 E1CE 60                    rts   
2884 E1CF
2885 E1CF                       ENDP 
2886 E1CF
2887 E1CF                       END   
